//
//  YHPickTimeHoldView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/10/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPickTimeHoldView: UIView {
    
//    var clickConfirmBtnBlock: ((YHResignConfirmHKStatus) -> Void)?
//    
//    var confirmHKStatus: YHResignConfirmHKStatus = .waitConfirmHK
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var applicantNamesLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 14)
        label.textColor = .mainTextColor
        label.text = "具体时间"
        return label
    }()
    
    private lazy var iconImageV: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "other_info_warning")
        view.contentMode = .scaleAspectFill
        return view
    }()
    
    private lazy var arrowIcon: UIImageView = {
        let view = UIImageView()
        view.image = UIImage(named: "right_arrow_black_20")
        return view
    }()
    
    lazy var timeTextField: UITextField = {
        let tf = UITextField()
        tf.font = UIFont.PFSC_M(ofSize: 14)
        tf.textColor = UIColor.mainTextColor
        tf.placeholder = "请选择"
        tf.isEnabled = false
        tf.textAlignment = .right
        return tf
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    @objc func didConfirmInHKBtnClicked() {
//        clickConfirmBtnBlock?(self.confirmHKStatus)
    }
    
    func createUI() {
        addSubview(lineView)
        addSubview(applicantNamesLabel)
        addSubview(iconImageV)
        addSubview(arrowIcon)
        addSubview(timeTextField)

        lineView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(1)
        }
        
        applicantNamesLabel.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.centerY.equalToSuperview().offset(1)
        }
        
        iconImageV.snp.makeConstraints { make in
            make.left.equalTo(applicantNamesLabel.snp.right).offset(4)
            make.centerY.equalTo(applicantNamesLabel)
            make.height.width.equalTo(kMargin)
        }
        
        let tap: UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        iconImageV.isUserInteractionEnabled = true
        iconImageV.addGestureRecognizer(tap)
        
        arrowIcon.snp.makeConstraints { make in
            make.right.equalToSuperview().offset(-kMargin)
            make.centerY.equalTo(applicantNamesLabel)
            make.height.width.equalTo(16)
        }
        
        timeTextField.snp.makeConstraints { make in
            make.right.equalTo(arrowIcon.snp.left).offset(-10)
            make.centerY.equalTo(applicantNamesLabel)
            make.width.equalTo(80)
        }
    }
}

private extension YHPickTimeHoldView {
    @objc func tapButton(gestureRecognizer: UITapGestureRecognizer) {
        YHWholeScreenTipsView.show(type: .renewTimeTips, targetView: iconImageV)
    }
}
