//
//  YHPreviewInfoQuestionAndAnswerItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPreviewInfoQuestionAndAnswerItemsView2: UIView {
    var dataModel: YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoQuestionAndAnswerItemsView2 {
    func updateUI() {
        guard let model = dataModel else { return }
        guard let arrData = model.cellData0, arrData.count > 0 else { return }
        removeSubviews()
        
        var lastTagView: UIView?
        if !model.cellTitle.isEmpty {
            let sessionView = YHPreviewInfoSingleLineTitleView()
            sessionView.updateTitle(title: model.cellTitle)
            addSubview(sessionView)
            sessionView.snp.makeConstraints { make in
                make.top.equalToSuperview()
                make.right.equalToSuperview().offset(0)
                make.left.equalToSuperview().offset(0)
                make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
            }
            lastTagView = sessionView
        }
        
        if arrData.count == 1 {
            let item = arrData[0]
            let cellView = YHPreviewInfoQuestionAndAnswerItemView2()
            cellView.dataModel = item
            addSubview(cellView)
            if lastTagView == nil {
                cellView.snp.makeConstraints { make in
                    make.top.equalToSuperview()
                    make.right.equalToSuperview().offset(-kMargin)
                    make.left.equalToSuperview().offset(kMargin)
                    make.bottom.equalToSuperview().offset(-12)
                }
                
            } else {
                cellView.snp.makeConstraints { make in
                    make.top.equalTo(lastTagView!.snp.bottom)
                    make.right.equalToSuperview().offset(-kMargin)
                    make.left.equalToSuperview().offset(kMargin)
                    make.bottom.equalToSuperview().offset(-12)
                }
            }
        } else {
            var tmp: UIView? = lastTagView
            for(index, item) in arrData.enumerated() {
                let cellView = YHPreviewInfoQuestionAndAnswerItemView2()
                cellView.dataModel = item
                addSubview(cellView)
                
                if index == arrData.count - 1 {
                    
                    if tmp == nil {
                        cellView.snp.makeConstraints { make in
                            make.top.equalToSuperview()
                            make.right.equalToSuperview().offset(-kMargin)
                            make.left.equalToSuperview().offset(kMargin)
                            make.bottom.equalToSuperview().offset(-12)
                        }
                    } else {
                        cellView.snp.makeConstraints { make in
                            make.top.equalTo(tmp!.snp.bottom)
                            make.right.equalToSuperview().offset(-kMargin)
                            make.left.equalToSuperview().offset(kMargin)
                            make.bottom.equalToSuperview().offset(-12)
                        }
                    }
                    
                } else {
                    
                    if tmp == nil {
                        cellView.snp.makeConstraints { make in
                            make.top.equalToSuperview()
                            make.right.equalToSuperview().offset(-kMargin)
                            make.left.equalToSuperview().offset(kMargin)
                        }
                        
                    } else {
                        cellView.snp.makeConstraints { make in
                            make.top.equalTo(tmp!.snp.bottom)
                            make.right.equalToSuperview().offset(-kMargin)
                            make.left.equalToSuperview().offset(kMargin)
                        }
                    }
                }
                tmp = cellView
            }
        }
    }
}
