//
//  YHResignDocumentStatus.swift
//  galaxy
//
//  Created by alexzzw on 2024/9/11.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

/*
   文书状态：0-待生成；1-初始化生成中；2-初始化已生成；3-等待初审；4-初审驳回；5-客户首次确认中；6-客户编辑确认；7-再次待审核；8-再次审核驳回；9-客户再次确认中；10-客户已签字确认；11-管理员编辑待提交；12-已定稿; 13-客户上传待确认
   0-4的状态码没有，从5开始，固定0-12
 5-客户首次确认中；  待确认
 6-客户编辑确认；    待审核
 7-再次待审核；      待审核
 8-再次审核驳回；    待审核
 9-客户再次确认中    待签字
 10-客户已签字确认   定稿中
 11-已定稿          定稿中
 12                已完成
 13                待审核
 */

enum YHResignDocumentStatus {
    case pendingConfirmation
    case finalizing
    case underReview
    case awaitingSignature
    case completed
    
    static func getStatus(_ number: Int) -> YHResignDocumentStatus? {
        switch number {
        case 0 ... 5:
            return .pendingConfirmation
        case 6 ... 8, 13:
            return .underReview
        case 9:
            return .awaitingSignature
        case 10, 11:
            return .finalizing
        case 12:
            return .completed
        default:
            return nil
        }
    }
    
    func title() -> String {
        switch self {
        case .pendingConfirmation:
            "待确认".local
        case .finalizing:
            "定稿中".local
        case .underReview:
            "审核中".local
        case .awaitingSignature:
            "待签字".local
        case .completed:
            "已完成".local
        }
    }
    
    func textColor() -> UIColor {
        switch self {
        case .pendingConfirmation:
            UIColor.brandMainColor
        case .finalizing:
            UIColor.yhOrangeColor
        case .underReview:
            UIColor.yhOrangeColor
        case .awaitingSignature:
            UIColor.brandMainColor
        case .completed:
            UIColor.yhGreenColor
        }
    }
    
    func iconName() -> String {
        switch self {
        case .pendingConfirmation:
            "blue_right_arrow"
        case .finalizing:
            "orange_right_arrow"
        case .underReview:
            "orange_right_arrow"
        case .awaitingSignature:
            "blue_right_arrow"
        case .completed:
            "green_right_arrow"
        }
    }
}
