//
//  YHResignUploadDetailViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/10/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHResignUploadDetailViewModel: YHBaseViewModel {
    // 列表信息
    var mainModel: YHResignUploadDetailModel = YHResignUploadDetailModel()
}

extension YHResignUploadDetailViewModel {
    
    func getUploadDocDetail(id: Int, callBackBlock: @escaping (_ success: Bool, _ err: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignUploadDoc.detail
        _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String: Any], let resultModel = YHResignUploadDetailModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callBackBlock(false, err)
                    return
                }
                self.mainModel = resultModel
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func postUploadDocFillUnavailableReason(id: Int, reason: String, callBackBlock: @escaping (_ success: Bool, _ err: YHErrorModel?) -> Void) {
        let params: [String: Any] = ["id": id, "unavailable_reason": reason]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignUploadDoc.reason
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
    func postUploadDocUpload(id: Int, file: [YHResignUploadDetailFileListModel], callBackBlock: @escaping (_ success: Bool, _ err: YHErrorModel?) -> Void) {
        var urls: [Any] = []
        for item in file {
            let file = ["name": item.name, "url": item.url, "updated_at": item.updated_at]
            urls.append(file)
        }
        let params: [String: Any] = ["id": id, "file_list": urls]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.ResignUploadDoc.upload
        _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, _ in
            // 1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                callBackBlock(true, nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false, err)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
    
}
