//
//  YHMemberCenterCellContent.swift
//  galaxy
//
//  Created by alexzzw on 2025/2/18.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation

enum YHMemberCenterCellContent: String, CaseIterable {
    case kidsBay = "kidsbay高端早教盒子"
    case luxury = "奢华会客体验中心"
    case crossBorder = "深港跨境出行预约"
    case hkTravel = "香港境内出行预约"
    case drivingLicense = "国际驾照续期"
    case schoolSelection = "香港择校规划"
    case brandPlanning = "品牌策划方案"
    case highEndMeeting = "高端私董会"
    case afternoonTea = "银河体验中心下午茶"
    case offlineSalons = "特色线下沙龙&分享会"
    case onSiteConsultation = "资深顾问上门咨询解答"
    case customerService = "专属客服服务"
    case pointsConsumption = "专属积分商城消费"
    
    func imageUrl() -> String {
        switch self {
        case .kidsBay:
            return "member_cell_kidsbay"
        case .luxury:
            return "member_cell_luxury"
        case .crossBorder:
            return "member_cell_crossBorder"
        case .hkTravel:
            return "member_cell_hkTravel"
        case .drivingLicense:
            return "member_cell_drivingLicense"
        case .schoolSelection:
            return "member_cell_schoolSelection"
        case .brandPlanning:
            return "member_cell_brandPlanning"
        case .highEndMeeting:
            return "member_cell_highEndMeeting"
        case .afternoonTea:
            return "member_cell_afternoonTea"
        case .offlineSalons:
            return "member_cell_offlineSalons"
        case .onSiteConsultation:
            return "member_cell_onSiteConsultation"
        case .customerService:
            return "member_cell_customerService"
        case .pointsConsumption:
            return "member_cell_pointsConsumption"
        }
    }
    
    func imageRatio() -> CGFloat {
        switch self {
        case .kidsBay:
            return 180.0 / 311.0
        case .luxury:
            return 180.0 / 311.0
        case .crossBorder:
            return 180.0 / 311.0
        case .hkTravel:
            return 180.0 / 311.0
        case .drivingLicense:
            return 126.0 / 311.0
        case .schoolSelection:
            return 65.0 / 311.0
        case .brandPlanning:
            return 65.0 / 311.0
        case .highEndMeeting:
            return 180.0 / 311.0
        case .afternoonTea:
            return 65.0 / 311.0
        case .offlineSalons:
            return 180.0 / 311.0
        case .onSiteConsultation:
            return 180.0 / 311.0
        case .customerService:
            return 65.0 / 311.0
        case .pointsConsumption:
            return 108.0 / 311.0
        }
    }
}
