//
//  YHInvitationWithGiftsViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/7/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHInvitationWithGiftsViewModel: YHBaseViewModel {
    var model: [YHShareCashOutModel] = []
    var overviewModel: YHShareOverviewModel = YHShareOverviewModel()
    var recordModel: YHShareRecordModel = YHShareRecordModel()
    var startTime: String = ""
    var endTime: String = ""
    var state: Int = 100
    // 提取纪录
    func getCashOutRecord(callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Share.cashOut
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = [YHShareCashOutModel].deserialize(from: dic as? [Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                self.model = (result as! [YHShareCashOutModel])
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            
            callBackBlock(false,err)
        }
    }

    func getOverviewRecord(callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Share.overview
        var param: [String : Any] = [:]
        if self.startTime.count != 0 {
            param.updateValue(self.startTime, forKey: "registered_date.begin_date")
        }
        if self.endTime.count != 0 {
            param.updateValue(self.endTime, forKey: "egistered_date.end_date")
        }
        if self.state < 3 {
            param.updateValue(self.state + 1, forKey: "status")
        }
        let _ = YHNetRequest.getRequest(url: strUrl, params: param) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = YHShareOverviewModel.deserialize(from: dic as? [String:Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                self.overviewModel = result
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    func postRecord(page: Int, callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Share.record
        var registered_date: [String: Any] = [:]
        if self.startTime.count != 0 {
            registered_date.updateValue(self.startTime, forKey: "begin_date")
        }
        if self.endTime.count != 0 {
            registered_date.updateValue(self.endTime, forKey: "end_date")
        }
        var param: [String: Any] = ["page": page,
                                    "pagesize": 20]
        if self.state < 3 {
            param.updateValue(self.state + 1, forKey: "status")
        }
        if !registered_date.isEmpty {
            param.updateValue(registered_date, forKey: "registered_date")
        }
        
        let _ = YHNetRequest.postRequest(url: strUrl, params: param) { [weak self] json, code in
            guard let self = self else { return }
            //1. json字符串 转 对象
            if json.code == 200 {
                let dic = json.data
                guard let result = YHShareRecordModel.deserialize(from: dic as? [String:Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                self.recordModel = result
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}
