//
//  BsHomeBannerView.swift
//  BaiSiSMApp
//
//  Created by SJ on 2022/11/9.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import Foundation
import FSPagerView
import Kingfisher

let bannerSildingInterval = 3.0

class YHHomeBannerView: UIView {
    static let viewH : CGFloat = KScreenWidth - 20.0 * 2
    var dataArr: [YHBannerModel] = [] {
        didSet {
            // 设置为0是先停掉自动滑动定时器
            bannerView.automaticSlidingInterval = 0
            self.indicatorView.indicatorItems = self.dataArr.count
            bannerView.reloadData()
            // 指定指示器为第一个
            self.indicatorView.curIndicatorIndex = 0
            // 指定显示图片为第一个
            bannerView.selectItem(at: 0, animated: false)
            // 开启定时器开始滚动
            bannerView.automaticSlidingInterval = bannerSildingInterval
            bannerView.removesInfiniteLoopForSingleItem = true
            bannerView.alwaysBounceHorizontal = true
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var bannerView: FSPagerView = {
        let view = FSPagerView()
        view.delegate = self
        view.dataSource = self
        view.bounces = false
        view.isInfinite = true
        view.automaticSlidingInterval = bannerSildingInterval
        view.register(YHHomeBannerCollectionViewCell.self, forCellWithReuseIdentifier: "cell")
        view.itemSize = CGSizeMake(YHHomeBannerView.viewH, YHHomeBannerView.viewH)//FSPagerView.automaticSize
        return view
    }()
    
    lazy var indicatorView : YHHomeBannerIndicatorView = {
        let view = YHHomeBannerIndicatorView()
        return view
    }()
}

private extension YHHomeBannerView {
    func initView() {
        addSubview(bannerView)
        bannerView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.equalToSuperview()
            make.right.equalToSuperview()
            make.height.equalTo(YHHomeBannerView.viewH)
        }
        
        bannerView.addSubview(indicatorView)
        indicatorView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(2)
            make.bottom.equalTo(-14)
        }
        bannerView.reloadData()
    }
    
    func goAppTab(tabBarName : String) {
        if !tabBarName.isEmpty {
            if tabBarName.contains("tabBarHome",caseSensitive: false) {
                //首页
                goTabBarBy(tabType: .home)
            } else if tabBarName.contains("tabBarService",caseSensitive: false) {
                //服务中心
                goTabBarBy(tabType: .service)
            } else if tabBarName.contains("tabBarMsg",caseSensitive: false) {
                //社区
                goTabBarBy(tabType: .community)
            } else if tabBarName.contains("tabBarMine",caseSensitive: false) {
                //我的
                goTabBarBy(tabType: .mine)
            } else if tabBarName.contains("invitation_with_gifts",caseSensitive: false) {
                
                if YHLoginManager.shared.isLogin() {
                    let vc = YHInvitationWithGiftsViewController()
                    UIViewController.current?.navigationController?.pushViewController(vc)
                } else {
                    YHOneKeyLoginManager.shared.oneKeyLogin()
                }
                
            } else {
                
            }
        }
    }
}

extension YHHomeBannerView: FSPagerViewDataSource, FSPagerViewDelegate {
    
    public func numberOfItems(in pagerView: FSPagerView) -> Int {
        return self.dataArr.count
    }
    
    public func pagerView(_ pagerView: FSPagerView, cellForItemAt index: Int) -> FSPagerViewCell {
        let cell = pagerView.dequeueReusableCell(withReuseIdentifier: "cell", at: index) as! YHHomeBannerCollectionViewCell
        if index < dataArr.count {
            cell.dataModel = dataArr[index]
        }
        return cell
    }
    
    // MARK: - FSPagerView Delegate
    func pagerView(_ pagerView: FSPagerView, didSelectItemAt index: Int) {
        pagerView.deselectItem(at: index, animated: true)
        pagerView.scrollToItem(at: index, animated: true)
        if index >= dataArr.count {
            return
        }
        let model = dataArr[index]
        if model.isLocalItemFlag {
            return
        }
        if model.skip_url.isEmpty == false {
            switch model.skip_type {
            case 1: //跳转H5
                let vc = YHHomeWebViewController()
                vc.url = model.skip_url
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 2: //跳转APP内Tab
                goAppTab(tabBarName:model.skip_url)
            case 3://3-跳转资讯页
                let vc = YHHomeWebViewController()
                vc.url = model.skip_url
                self.parentViewController?.navigationController?.pushViewController(vc)
            case 0://0 不需要跳转
                printLog("0 不需要跳转")
            default:
                YHHUD.flash(message: "不需要处理的类型")
                break
            }
        } else {
            YHHUD.flash(message: "error:skip_url不能为空")
        }
    }
    
    func pagerViewWillEndDragging(_ pagerView: FSPagerView, targetIndex: Int) {
        self.indicatorView.curIndicatorIndex = targetIndex
    }
    
    func pagerViewDidEndScrollAnimation(_ pagerView: FSPagerView) {
        self.indicatorView.curIndicatorIndex = pagerView.currentIndex
    }
}
