//
//  YHHomeInfoSectionHeadView.swift
//  galaxy
//
//  Created by edy on 2024/7/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

let kHomeGap = 15.0
let kHomeItemWidth = floor((KScreenWidth-20.0*2.0-kHomeGap*2.0)/3.0)
let kHomeItemHeight = kHomeItemWidth+10.0+20.0+26.0

class YHHomeInfoSectionHeadView: UICollectionReusableView {
    
    static let reuseIdentifier = "YHHomeInfoSectionHeadView"

    var items:[YHHomeInfoClassifyModel?] = [] {
        didSet {
            self.collectView.reloadData()
            var row = items.count/3
            if row%3 != 0 {
                row = row + 1
            }
            let totalHeight = Double(row) * kHomeItemHeight
            self.collectView.snp.updateConstraints { make in
                make.height.equalTo(totalHeight)
            }
            self.bottomLineView.snp.updateConstraints { make in
                make.top.equalTo(self.collectView.snp.bottom).offset(items.count > 0 ? 4.0 : 0.0)
            }
            self.collectView.isHidden = items.count <= 0
            self.bottomLineView.isHidden = items.count <= 0
            self.titleLabel.isHidden = items.count <= 0
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    lazy var collectView = {
        // 设置布局方向
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.minimumInteritemSpacing = kHomeGap
        flowLayout.minimumLineSpacing = 0.0
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.register(YHHomeInfoSectionCell.self, forCellWithReuseIdentifier:YHHomeInfoSectionCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.translatesAutoresizingMaskIntoConstraints = false
        collectinoView.isScrollEnabled = false
        collectinoView.showsVerticalScrollIndicator = false
        return collectinoView
    }()
    
    lazy var bottomLineView:UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.init(hex: 0xF0F3F7)
        return view
    }()
    
    lazy var titleLabel: UILabel =  {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 18)
        label.textAlignment = .left
        label.textColor = UIColor.mainTextColor
        label.text = "最新资讯"
        return label
    }()
        
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        self.backgroundColor = .white
        self.addSubview(collectView)
        self.addSubview(bottomLineView)
        self.addSubview(titleLabel)
        collectView.snp.makeConstraints { make in
            make.top.equalTo(0)
            make.left.right.equalToSuperview()
            make.height.equalTo(0)
        }
        bottomLineView.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.top.equalTo(collectView.snp.bottom).offset(4.0)
            make.height.equalTo(0.5)
        }
        titleLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(65)
            make.top.equalTo(bottomLineView.snp.bottom)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension YHHomeInfoSectionHeadView: UICollectionViewDelegate, UICollectionViewDataSource, UICollectionViewDelegateFlowLayout {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        // 最新资讯
        return self.items.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHHomeInfoSectionCell.cellReuseIdentifier, for: indexPath) as! YHHomeInfoSectionCell
        if 0 <= indexPath.row, indexPath.row < self.items.count {
            if let item = self.items[indexPath.row] {
                cell.updateModel(item)
            }
        }
        return cell
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        if 0 <= indexPath.row, indexPath.row < self.items.count {
            if let item = self.items[indexPath.row] {
                let vc = YHHomeInfoDetailContainerViewController()
                vc.customTitle = item.name
                vc.isHaveHot = item.hotNum > 0
                vc.classifyId = item.id
                UIViewController.current?.navigationController?.pushViewController(vc)
            }
        }
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        return CGSize(width: kHomeItemWidth, height: kHomeItemHeight)
    }
}
