//
//  YHHomeWebBottomView.swift
//  galaxy
//
//  Created by EDY on 2024/4/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Lottie

enum YHTintColorMode {
    case light
    case dark
}

class YHHomeWebBottomView: UIView {
    
    static let height = 59.0
    
    typealias Block = (Bool) -> ()
    var likeBlock: Block?
    var starBlock: Block?
    var likeButton: YHHomeWebBottomButton!
    var starButton: YHHomeWebBottomButton!
    var animationView: LottieAnimationView!
    var likeCount: Int = 0
    var starCount: Int = 0
    var isStar: Bool = false {
        didSet {
            let imgName = isStar ? "home_web_stared" : "home_web_star"
            var image = UIImage(named: imgName)
            if tintMode == .dark {
                starButton.bottomTitleLabel.textColor = .white
                if !isStar {
                    image = image?.withRenderingMode(.alwaysTemplate).withTintColor(.white)
                    starButton.topImageView.tintColor = .white
                }
            }
            starButton.setContent(image, "\(starCount)")
        }
    }//是否收藏
    
    var isLike: Bool = false {
        didSet {
            let imgName = isLike ?  "home_web_liked" : "home_web_like"
            var image = UIImage(named: imgName)
            if tintMode == .dark {
                likeButton.bottomTitleLabel.textColor = .white
                if !isLike {
                    image = image?.withRenderingMode(.alwaysTemplate).withTintColor(.white)
                    likeButton.topImageView.tintColor = .white

                }
            }
            if animationView.isHidden {
                likeButton.setContent(image, "\(likeCount)")
            } else {
                likeButton.setContent(UIImage(named: ""), "\(likeCount)")
            }
        }
    }//是否点赞
    
    var tintMode: YHTintColorMode = .light {
        didSet {
            if tintMode == .light {
                self.backgroundColor = .white
                
            } else if tintMode == .dark {
                self.backgroundColor = .black
            }
        }
    }

    override init(frame: CGRect) {
        super.init(frame: frame)
        tintMode = .light
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        animationView = {
            let view = LottieAnimationView(name: "zixun")
            view.isHidden = true
            return view
        }()
        addSubview(animationView)
        animationView.snp.makeConstraints { make in
            make.right.equalTo(-72)
            make.top.equalTo(2.5)
            make.height.equalTo(36)
            make.width.equalTo(36)
        }
        likeButton = {
            let button = YHHomeWebBottomButton()
            button.setContent(UIImage(named:"home_web_like"), "0")
            button.addTarget(self, action: #selector(likeBtnClick), for: .touchUpInside)
            return button
        }()
        addSubview(likeButton)
        likeButton.snp.makeConstraints { make in
            make.centerX.equalTo(animationView.snp.centerX)
            make.top.equalTo(10)
            make.height.equalTo(39)
            make.width.equalTo(24)
        }
        
        starButton = {
            let button = YHHomeWebBottomButton()
            button.setContent(UIImage(named:"home_web_star"), "0")
            button.addTarget(self, action: #selector(starBtnClick), for: .touchUpInside)
            return button
        }()
        addSubview(starButton)
        starButton.snp.makeConstraints { make in
            make.right.equalTo(-31)
            make.top.equalTo(10)
            make.height.equalTo(39)
            make.width.equalTo(24)
        }
    }
    
    @objc private func likeBtnClick() {
        if YHNetworkStatusManager.shared.isNetWorkOK == false {
            YHHUD.flash(message: "网络不可用，请检查网络设置")
            return
        }
        if YHLoginManager.shared.isLogin() == false {
            if let block = likeBlock {
                block(isLike)
            }
            return
        }
        isLike = !isLike
        if isLike {
            animationView.isHidden = false
            animationView.loopMode = .playOnce
            animationView.play {[weak self] completed in
                guard let self = self else { return }
//                self.animationView.isHidden = true
            }
        } else {
            animationView.isHidden = true
        }
        if let block = likeBlock {
            block(isLike)
        }
    }
    
    @objc private func starBtnClick() {
        if YHNetworkStatusManager.shared.isNetWorkOK == false {
            YHHUD.flash(message: "网络不可用，请检查网络设置")
            return
        }
        if YHLoginManager.shared.isLogin() == false {
            if let block = starBlock {
                block(isStar)
            }
            return
        }
        
        isStar = !isStar
        if let block = starBlock {
            block(isStar)
        }
    }
}
