//
//  YHOrderTipsView.swift
//  galaxy
//
//  Created by edy on 2024/6/4.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHOrderTipsView: UIView {

    private static let viewH : CGFloat = 91.0
    private static let viewH2 : CGFloat = 162.0
    private static let viewH3 : CGFloat = 226.0
    
    
    var tipViewH : CGFloat {
        
        guard let arr = arrLastTwoMessage else {
            return YHOrderTipsView.viewH
        }
        
        if arr.count > 1 {
            return YHOrderTipsView.viewH3
        } else if arr.count == 1 {
            return YHOrderTipsView.viewH2
        }
        return YHOrderTipsView.viewH
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setupUI()
        
        let tap : UITapGestureRecognizer = UITapGestureRecognizer(target: self, action: #selector(tapButton(gestureRecognizer:)))
        addGestureRecognizer(tap)
    }
    
    
    var dataModelForBasicInfo : YHSignerInfoModel? {
        didSet {
            updateBasicInfo()
        }
    }
    
    
    var arrLastTwoMessage : [YHHomeLastMessageModel]? {
        didSet {
            updateLastTwoMessges()
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bkgImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_order_tips_bkg")
        imgV.clipsToBounds = true
        return imgV
    }()
    
    lazy var topImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_order_tips_top_bkg")
        return imgV
    }()
    
    lazy var iconImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_order_tips_icon")
        return imgV
    }()
    
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        bkgImageV.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        
        if let arr = arrLastTwoMessage {
            if arr.count > 1 {
                firstItem.snp.makeConstraints { make in
                    make.top.equalTo(lableName.snp.bottom).offset(20)
                    make.left.equalTo(kMargin)
                    make.right.equalTo(-20)
                    make.height.equalTo(YHOrderTipsItemView.viewH)
                }
                secondItem.snp.makeConstraints { make in
                    make.top.equalTo(firstItem.snp.bottom).offset(12)
                    make.left.equalTo(kMargin)
                    make.right.equalTo(-20)
                    make.height.equalTo(YHOrderTipsItemView.viewH)
                }
            } else if arr.count == 1 {
                firstItem.snp.makeConstraints { make in
                    make.top.equalTo(lableName.snp.bottom).offset(20)
                    make.left.equalTo(kMargin)
                    make.right.equalTo(-kMargin)
                    make.height.equalTo(YHOrderTipsItemView.viewH)
                }
            }
        }
    }
    
    
    //智能助理
    lazy var lableTip: UILabel = {
        let lable : UILabel = UILabel()
        return lable
    }()
    
    //我的订单
    lazy var lableMyOrder: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "我的订单"
        lable.font = UIFont.PFSC_R(ofSize: 13)
        lable.textColor = UIColor.yhGreyColor
        return lable
    }()
    
    
    //右箭头
    lazy var rightIconImageV: UIImageView = {
        let imgV : UIImageView = UIImageView()
        imgV.contentMode = .scaleAspectFill
        imgV.image = UIImage(named: "home_order_tips_right_arrow")
        return imgV
    }()
    
    
    //上午好！张先生
    lazy var lableName: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "上午好！张先生"
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textColor = UIColor.mainTextColor50
        return lable
    }()
    
    //分割线
    lazy var segmentationView: UIView = {
        let view : UIView = UIView()
        view.backgroundColor = UIColor.mainTextColor18
        return view
    }()
    
    
    //银河港生活陪伴您的第190天
    lazy var lableDays: UILabel = {
        let lable : UILabel = UILabel()
        lable.text = "银河港生活陪伴您的第190天"
        lable.font = UIFont.PFSC_R(ofSize: 12)
        lable.textColor = UIColor.mainTextColor50
        return lable
    }()
    
    lazy var firstItem: YHOrderTipsItemView = {
        let itemView : YHOrderTipsItemView = YHOrderTipsItemView()
//        itemView.indexItem = 1
        itemView.isHidden = true
        return itemView
    }()
    
    lazy var secondItem: YHOrderTipsItemView = {
        let itemView : YHOrderTipsItemView = YHOrderTipsItemView()
//        itemView.indexItem = 2
        itemView.isHidden = true
        return itemView
    }()
}

private extension YHOrderTipsView {
    func timeName() -> String {
        let now = Date()
        let hour = Calendar.current.component(.hour, from: now)
        var name = ""
        if hour < 12 {
            name = "上午"
        } else if hour < 18 {
            name = "下午"
        } else {
            name = "晚上"
        }
        return name
    }

    func updateBasicInfo() {
        guard let model = dataModelForBasicInfo else {
            return
        }
        
        lableName.text = timeName() + "好，" + model.name + model.sex.sexDescribe()
        
        let now = Date()
        let timestamp = now.timeIntervalSince1970
        print("当前时间戳：\(timestamp)")
        
        let offsetSecond = CGFloat(Int64(timestamp) - model.registration_timestamp)
        
        if offsetSecond > 0 {
            let roundedUp = Int(ceil(offsetSecond / (24 * 60 * 60)))
            lableDays.text = "银河港生活陪伴您的第" + String(roundedUp) + "天"
        } else {
            lableDays.text = "银河港生活陪伴在您的身边"
        }
        layoutIfNeeded()
    }
    
    func updateLastTwoMessges() {
        guard let arr = arrLastTwoMessage else {
            firstItem.isHidden = true
            secondItem.isHidden = true
            return
        }
        if arr.count > 1 {
            firstItem.isHidden = false
            secondItem.isHidden = false
        } else if arr.count == 1 {
            firstItem.isHidden = false
            secondItem.isHidden = true
        } else {
            firstItem.isHidden = true
            secondItem.isHidden = true
        }
        
        if let first = arrLastTwoMessage?.first, let last = arrLastTwoMessage?.last {
            firstItem.message = first
            secondItem.message = last
        }
        setNeedsLayout()
        layoutIfNeeded()
    }
    
    
    
    @objc func tapButton(gestureRecognizer:UITapGestureRecognizer) {
        goTabBarBy(tabType: .service)
    }
    
    
    func setupUI() {
        
        backgroundColor = UIColor.pageBkgColor
        
        clipsToBounds = true
        addSubview(bkgImageV)
        bkgImageV.snp.makeConstraints { make in
            make.left.top.equalToSuperview()
            make.width.equalTo(KScreenWidth - 40)
            make.height.equalTo(YHOrderTipsView.viewH)
        }
        
        addSubview(topImageV)
        topImageV.snp.makeConstraints { make in
            // 182  99
            make.top.left.equalToSuperview()
            make.width.equalTo(182)
            make.height.equalTo(99)
        }
        
        
        
        
        //智能头像
        addSubview(iconImageV)
        iconImageV.snp.makeConstraints { make in
            make.top.equalTo(18)
            make.left.equalTo(kMargin)
            make.width.height.equalTo(27)
        }
        
        
        addSubview(lableTip)
        lableTip.snp.makeConstraints { make in
            make.centerY.equalTo(iconImageV)
            make.left.equalTo(iconImageV.snp.right).offset(6)
        }
        
        let aa: ASAttributedString = .init("智能", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("助理", .font(UIFont.PFSC_B(ofSize: 17)),.foreground(UIColor.mainTextColor))
        lableTip.attributed.text = aa+bb
        
        
        addSubview(rightIconImageV)
        rightIconImageV.snp.makeConstraints { make in
            make.right.equalTo(-20)
            make.top.equalTo(23)
            make.width.height.equalTo(12)
        }
        
        
        addSubview(lableMyOrder)
        lableMyOrder.snp.makeConstraints { make in
            make.right.equalTo(rightIconImageV.snp.left)
            make.centerY.equalTo(rightIconImageV)
            make.height.equalTo(18)
        }
        
        
        
        
        addSubview(lableName)
        lableName.snp.makeConstraints { make in
            make.top.equalTo(iconImageV.snp.bottom).offset(9)
            make.left.equalTo(iconImageV.snp.left)
            make.height.equalTo(17)
        }
        
        
        addSubview(segmentationView)
        segmentationView.snp.makeConstraints { make in
            make.left.equalTo(lableName.snp.right).offset(8)
            make.height.equalTo(10)
            make.width.equalTo(1)
            make.centerY.equalTo(lableName.snp.centerY)
        }
        
        
        
        addSubview(lableDays)
        lableDays.snp.makeConstraints { make in
            make.left.equalTo(segmentationView.snp.right).offset(8)
            make.height.equalTo(17)
            make.centerY.equalTo(segmentationView.snp.centerY)
//            make.right.equalTo(-kMargin)
        }
        
        
        addSubview(firstItem)
        addSubview(secondItem)
        
        layoutIfNeeded()
        setNeedsLayout()
    }
}
