//
//  YHServiceOrderAlertView.swift
//  galaxy
//
//  Created by EDY on 2024/4/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHServiceOrderAlertView: UIView {
    var centerView: UIView!
    var titleLabel: UILabel!
    var closeButton: UIButton!
    var lineView: UIView!
    var knowButton: UIButton!
    var measageLabel: UILabel!
    var subMeasageLabel: UILabel!

    static func show() {
        let view = YHServiceOrderAlertView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: KScreenHeight))
        let window = UIApplication.shared.yhKeyWindow()
        window?.addSubview(view)
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = UIColor(white: 0.5, alpha: 0.1)
        let tap = UITapGestureRecognizer(target: self, action: #selector(handleTap))
        tap.delegate = self
        addGestureRecognizer(tap)
        setView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setView() {
        backgroundColor = UIColor(hex: 0x0000, alpha: 0.5)
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius8
            return view
        }()
        addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(401)
        }
        
        titleLabel = {
            let label = UILabel()
            label.text = "原因说明"
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.textAlignment = .center
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.height.equalTo(21)
            make.right.equalTo(-21)
        }
        
        closeButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "service_card_close"), for: .normal)
            button.addTarget(self, action: #selector(dismiss), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(closeButton)
        closeButton.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.width.height.equalTo(24)
            make.top.equalTo(16)
        }
        
        lineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(lineView)
        lineView.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(52)
            make.height.equalTo(1)
        }
        
        knowButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
            button.contentHorizontalAlignment = .center
            button.setTitle("我知道了", for: .normal)
            button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(knowButton)
        knowButton.snp.makeConstraints { make in
            make.right.equalTo(-16)
            make.left.equalTo(16)
            make.height.equalTo(48)
            make.bottom.equalTo(-29)
        }
        
        measageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(measageLabel)
        measageLabel.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(73)
        }
        
        subMeasageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(subMeasageLabel)
        subMeasageLabel.snp.makeConstraints { make in
            make.right.equalTo(-21)
            make.left.equalTo(21)
            make.top.equalTo(157)
        }
        
        let a: ASAttributedString = .init("1.当前仅支持查看", .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.7)))
        
        let aa: ASAttributedString = .init(NSAttributedString(string: "优才订单"), .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.brandMainColor))
        
        
        let aaa: ASAttributedString = .init("，如果是签约了其他高才、专才、留学等订单，请与您的服务管家或销售顾问企微沟通联系哦", .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.7)))
        
        let b: ASAttributedString = .init(NSAttributedString(string: "2.使用其他手机号签约合同/订单，请退出登录"), .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.7)))
        
        let bb: ASAttributedString = .init("切换账号", .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.brandMainColor))
        let bbb: ASAttributedString = .init("查看", .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.mainTextColor.withAlphaComponent(0.7)))

        measageLabel.attributed.text = a + aa + aaa
        subMeasageLabel.attributed.text = b + bb + bbb
        
        knowButton.backgroundColor = .brandMainColor
        knowButton.addYinHeGradualLayer()
    }
    
    @objc private func handleTap(_ sender: AnyObject?) {
        print("处理点击手势")
        dismiss()
    }
    
    @objc func dismiss() {
        removeFromSuperview()
    }
    
    @objc func goNext() {
        dismiss()
    }
}

extension YHServiceOrderAlertView: UIGestureRecognizerDelegate {
    func gestureRecognizer(_ gestureRecognizer:UIGestureRecognizer, shouldReceive touch:UITouch) -> Bool {
        if touch.view == self {
            return true
        }
        return false
    }
}


