//
//  YHStatusAdvantageBottomView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/7/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHStatusAdvantageBottomView: UIView {
    static let viewH : CGFloat = 98.0
    
    override init(frame: CGRect) {
        super.init(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: YHBasicInfoFillBottomView.viewH))
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    
    
    typealias Block = (Int) -> () //0-快速测评 1-资讯顾问 2-分享有礼
    var block: Block?
    
    var hasOrder : Bool = false {
        didSet {
            setNeedsLayout()
        }
    }
    
    
    lazy var topLine: UIView = {
        let line = UIView()
        line.backgroundColor = UIColor.separatorColor
        return line
    }()
    
    //快速测评
    lazy var quickEvaluationBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("快速测评", for: .normal)
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickEvaluationBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.contentBkgColor
        return button
    }()
    
    //咨询顾问
    lazy var consultantBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("咨询顾问", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickConsultantBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.brandMainColor
        return button
    }()
    
    
    //邀请有礼
    lazy var rewardBtn: UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("邀请有礼", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickRewardBtn), for: .touchUpInside)
        button.backgroundColor = UIColor.brandMainColor
        return button
    }()
    
    
    override func layoutSubviews() {
        super.layoutSubviews()
        
        if YHLoginManager.shared.isLogin() {
            if hasOrder {
                quickEvaluationBtn.isHidden = true
                consultantBtn.isHidden = true
                rewardBtn.isHidden = false
                
            } else {
                quickEvaluationBtn.isHidden = false
                consultantBtn.isHidden = false
                rewardBtn.isHidden = true
            }
        } else {
            quickEvaluationBtn.isHidden = false
            consultantBtn.isHidden = false
            rewardBtn.isHidden = true
        }
    }
}

private extension YHStatusAdvantageBottomView {
    func setupUI() {
        backgroundColor = .white
        
        addSubview(topLine)
        addSubview(quickEvaluationBtn)
        addSubview(consultantBtn)
        addSubview(rewardBtn)
        
        
        topLine.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        quickEvaluationBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(10)
            make.left.equalTo(kMargin)
            make.right.equalTo(consultantBtn.snp.left).offset(-11)
            make.height.equalTo(44)
            make.width.equalTo(116)
        }
        
        
        consultantBtn.snp.makeConstraints { make in
            make.top.equalTo(quickEvaluationBtn.snp.top)
            make.left.equalTo(quickEvaluationBtn.snp.right).offset(11)
            make.right.equalTo(-kMargin)
            make.height.equalTo(44)
//            make.width.equalTo(116)
        }
        
        rewardBtn.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(10)
            make.left.equalTo(kMargin)
            make.right.equalTo(-kMargin)
            make.height.equalTo(44)
//            make.width.equalTo(116)
        }
        
        
        setNeedsLayout()
    }
    
    @objc func clickEvaluationBtn() {
        block?(0)
    }
    
    @objc func clickConsultantBtn() {
        block?(1)
    }
    
    @objc func clickRewardBtn() {
        block?(2)
    }
}
