//
//  YHHKControllerHoldViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHHKControllerHoldViewController: UIViewController {
    let homeViewModel: YHHomePageViewModel = YHHomePageViewModel()

    var canScroll : Bool = false {
        didSet {
            for vc in arrItemVCs {
                vc.vcCanScroll = canScroll
            }
        }
    }
    var items: [YHClassifyModel] = []
    var classID = 0
    
    var myDefaultNavItemIndex : Int = 0 {
        didSet {
            self.segmentedView.selectItemAt(index: self.myDefaultNavItemIndex)
        }
    }
    
    var arrItemTitles: [String] = []
    var arrItemVCs : [YHHKClassListViewController] = []
    var segmentedView : JXSegmentedView = JXSegmentedView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 55))
    lazy var segmentedDataSource: JXSegmentedTitleDataSource = {
        let dataSource = JXSegmentedTitleDataSource()
        dataSource.titles = arrItemTitles
        
        dataSource.titleNormalFont = UIFont.PFSC_R(ofSize: 14)
        dataSource.titleSelectedColor = UIColor.labelTextColor2
        
        dataSource.titleSelectedFont = UIFont.PFSC_M(ofSize: 14)
        dataSource.titleSelectedColor = UIColor.white
        dataSource.isTitleMaskEnabled = true
        dataSource.isItemSpacingAverageEnabled = false
        dataSource.itemWidth = JXSegmentedViewAutomaticDimension
        dataSource.itemSpacing = 24
        return dataSource
    }()
    
    
    //分类title 所对应的VC
    lazy var listContainerView: JXSegmentedListContainerView! = {
        return JXSegmentedListContainerView(dataSource: self, type: .collectionView)
    }()

    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        //segmentedViewDataSource一定要通过属性强持有！！！！！！！！！
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        view.addSubview(segmentedView)

        segmentedView.listContainer = listContainerView
        view.addSubview(listContainerView)
        
        
        //分类Title
        segmentedView.dataSource = segmentedDataSource
        segmentedView.delegate = self
        
        //配置指示器
        let indicator = JXSegmentedIndicatorBackgroundView()
        indicator.indicatorColor = UIColor.brandMainColor
        indicator.indicatorHeight = 32
        segmentedView.indicators = [indicator]
        segmentedView.defaultSelectedIndex = self.myDefaultNavItemIndex
        
        getData()
    }

    func getData() {
        homeViewModel.getHomeClassify{[weak self] success, error in
            guard let self = self, let classify = self.homeViewModel.classify  else { return }
            for item in classify {
                let model = item as YHHomeClassifyModel
                if model.id == self.classID {
                    self.items = model.children
                    self.arrItemTitles.removeAll()
                    for item in model.children {
                        self.arrItemTitles.append(item.name)
                        let vc = YHHKClassListViewController()
                        vc.classId = item.id
                        arrItemVCs.append(vc)
                    }
                }
                self.segmentedDataSource.titles = arrItemTitles
                self.segmentedView.dataSource = segmentedDataSource
                self.segmentedView.reloadData()
            }
        }
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)

        //处于第一个item的时候，才允许屏幕边缘手势返回
        navigationController?.interactivePopGestureRecognizer?.isEnabled = (segmentedView.selectedIndex == 0)
    }

    override func viewWillDisappear(_ animated: Bool) {
        super.viewWillDisappear(animated)

        //离开页面的时候，需要恢复屏幕边缘手势，不能影响其他页面
        navigationController?.interactivePopGestureRecognizer?.isEnabled = true
    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()

        segmentedView.frame = CGRect(x: 0, y: 0, width: view.bounds.size.width, height: 55)
        listContainerView.frame = CGRect(x: 0, y: 55, width: view.bounds.size.width, height: view.bounds.size.height - 55)
        segmentedView.backgroundColor = .white
    }
}

extension YHHKControllerHoldViewController: JXSegmentedViewDelegate {
    func segmentedView(_ segmentedView: JXSegmentedView, didSelectedItemAt index: Int) {
        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewDidEndDragging0"), object: nil)
        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewDidToTop"), object: nil)
    }

    /// 正在滚动中的回调
    ///
    /// - Parameters:
    ///   - segmentedView: JXSegmentedView
    ///   - leftIndex: 正在滚动中，相对位置处于左边的index
    ///   - rightIndex: 正在滚动中，相对位置处于右边的index
    ///   - percent: 从左往右计算的百分比
    func segmentedView(_ segmentedView: JXSegmentedView, scrollingFrom leftIndex: Int, to rightIndex: Int, percent: CGFloat) {
        NotificationCenter.default.post(name:  Notification.Name(rawValue: "scrollViewWillBeginDragging0"), object: nil)
    }
}

extension YHHKControllerHoldViewController: JXSegmentedListContainerViewDataSource {
    func numberOfLists(in listContainerView: JXSegmentedListContainerView) -> Int {
        if let titleDataSource = segmentedView.dataSource as? JXSegmentedBaseDataSource {
            return titleDataSource.dataSource.count
        }
        return 0
    }

    func listContainerView(_ listContainerView: JXSegmentedListContainerView, initListAt index: Int) -> JXSegmentedListContainerViewListDelegate {
        return arrItemVCs[index] as JXSegmentedListContainerViewListDelegate
    }
}
