//
//  YHHKIdentityCardViewController.swift
//  galaxy
//
//  Created by EDY on 2024/6/12.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import JXSegmentedView

class YHHKIdentityCardViewController: YHBaseViewController {
    let homeViewModel: YHHomePageViewModel = YHHomePageViewModel()
    var tableHeadView: YHServerTableHeadView!

    var orderId : Int?
    
    var canScroll : Bool = true
    var myCellHeight : CGFloat {
        get {
            return view.bounds.size.height
        }
    }
    
    var myDefaultIndex : Int = 0 {
        didSet {
            DispatchQueue.global().asyncAfter(wallDeadline: .now() ) {[weak self] in
                DispatchQueue.main.async {
                    self?.cellView.myDefaultNavItemIndex = self?.myDefaultIndex ?? 0
                }
            }
        }
    }
    
    lazy var cellView: YHHKControllerHoldViewController = {
        let ttt = YHHKControllerHoldViewController()
        ttt.classID = 1
        return ttt
    }()
    
    var homeTableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = false
        return tableView
    }()
    
    
    var myHeadView : UIView = {
        let view = UIView(frame: CGRect(x: kMargin, y: 0, width: KScreenWidth, height: 365))
        view.backgroundColor = .white
        return view
    }()
    
    
    //头像
    private lazy var headImagV : UIImageView = {
        let imageV = UIImageView(image: UIImage(named: "mine_head_default"))
        imageV.contentMode = .scaleAspectFill
        imageV.layer.cornerRadius = 26.5
        imageV.clipsToBounds = true
        imageV.layer.borderWidth = 2
        imageV.layer.borderColor = UIColor.white.cgColor
        return imageV
    }()
    
    //姓名
    private lazy var nameLable : UILabel = {
        let lable0 = UILabel(text: "")
        lable0.textColor = UIColor.mainTextColor
        lable0.font = UIFont.PFSC_M(ofSize: 19)
        return lable0
    }()
    
    //电话号码
    private lazy var phoneLable : UILabel = {
        let lable0 = UILabel(text: "")
        lable0.textColor = UIColor.labelTextColor2
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        return lable0
    }()
    
    
    // MARK: - 生命周期方法
    override func viewDidLoad() {
        super.viewDidLoad()
        
        
        NotificationCenter.default.addObserver(self, selector: #selector(leaveTopOp), name:Notification.Name(rawValue: "leaveTop0"), object: nil)
        
        
        NotificationCenter.default.addObserver(self, selector: #selector(beginDragging), name:Notification.Name(rawValue: "scrollViewWillBeginDragging0"), object: nil)
        
        
        NotificationCenter.default.addObserver(self, selector: #selector(endDragging), name:Notification.Name(rawValue: "scrollViewDidEndDragging0"), object: nil)
        
        NotificationCenter.default.addObserver(self, selector: #selector(scrDragging), name:Notification.Name(rawValue: "scrollViewDidToTop"), object: nil)
        //1.UI
        initView()
        
        //2.网络请求
        loadData()
//        updateDefaultSearchKeyWord()
    }
    
//    func updateDefaultSearchKeyWord() {
//        var placeHolder = "香港身份"
//        if isHaveLocalSearchRecords() {
//            let latestValidSearchWord = getLatestValidSearchWord()
//            if !latestValidSearchWord.isEmpty {
//                placeHolder = latestValidSearchWord
//            }
//        }
////        tableHeadView.searchPlaceHolder = placeHolder
//    }
    
    override func viewDidLayoutSubviews() {
        super.viewDidLayoutSubviews()
        cellView.view.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: myCellHeight)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
//        updateDefaultSearchKeyWord()
    }
}

// MARK: - 私有方法
extension YHHKIdentityCardViewController {
    func loadData() {
        self.tableHeadView.bannarView.dataArr = [YHBannerModel.localDefaultItem()]

        homeViewModel.getHomeBanner(1){[weak self] success, error in
            guard let self = self else { return }
            self.tableHeadView.bannarView.dataArr = self.homeViewModel.banners ?? [YHBannerModel.localDefaultItem()]
        }
        
    }
    
    private func initView() {
        gk_navigationBar.isHidden = true
        
        homeTableView.delegate = self
        homeTableView.dataSource = self
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.left.right.bottom.equalToSuperview()
        }
        tableHeadView = YHServerTableHeadView()
        tableHeadView.titleLabel.text = "香港身份攻略"
        tableHeadView.frame = CGRect(x: 0, y: -YHServerTableHeadView.viewH - 48, width: KScreenWidth, height: YHServerTableHeadView.viewH)
        homeTableView.tableHeaderView = tableHeadView
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHHKIdentityCardViewController : UITableViewDelegate,UITableViewDataSource {
    
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 0.001
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.001))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0.001
    }
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 0.001))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return myCellHeight
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = UITableViewCell()
        cellView.view.frame = CGRect(x: 0, y: 0, width: cell.contentView.bounds.size.width, height: myCellHeight)
        cell.contentView.addSubview(cellView.view)
        cellView.view.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
    }
}

extension YHHKIdentityCardViewController: UIScrollViewDelegate {
    func scrollViewDidScroll(_ scrollView: UIScrollView) {
        let bottomCellOffset: CGFloat = homeTableView.rect(forSection: 0).origin.y
        if (scrollView.contentOffset.y >= bottomCellOffset) {
            scrollView.contentOffset = CGPointMake(0, bottomCellOffset)
            if canScroll == true {
                canScroll = false
                //传递参数到 子VC
                cellView.canScroll = true
            }
            
            canScroll = false
            //传递参数到 子VC
            cellView.canScroll = true
        }else{
            if canScroll == false {
                scrollView.contentOffset = CGPoint(x: 0, y: bottomCellOffset)
            }
        }
        self.homeTableView.showsVerticalScrollIndicator = false
    }
}

extension YHHKIdentityCardViewController {
    @objc func leaveTopOp() {
        canScroll = true
    }
    
    @objc func beginDragging() {
        homeTableView.isScrollEnabled = false
        canScroll = false
    }
    
    @objc func endDragging() {
        homeTableView.isScrollEnabled = true
        canScroll = true
    }
    
    @objc func scrDragging() {
        homeTableView.setContentOffset(CGPoint(x: 0, y: 365), animated: true)
    }
}

extension YHHKIdentityCardViewController: JXSegmentedListContainerViewListDelegate {
    func listView() -> UIView {
        return view
    }
}
