//
//  YHServiceCenterSecondViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/24.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

//服务中心
class YHServiceCenterSecondViewController: YHBaseViewController {
    var orderId : Int = 0
    var mobile: String?
    private let serviceCenterMainReqVM : YHServiceCenterMainViewModel = YHServiceCenterMainViewModel()
    private var unfoldFlag : Bool = true //是否展开
    private lazy var downArrowImagev : UIImageView =  {
        let imagV = UIImageView(frame: CGRect(x: KScreenWidth - 16 - 32, y: 17, width: 16, height: 16))
        imagV.image = UIImage(named: "service_center_down_arrow")
        imagV.contentMode = .scaleAspectFill
        return imagV
    }()
    
    private lazy var topBkg : UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "service_center_head_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
        
    }()
    
    var homeTableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = false
        tableView.register(YHContractMainItemStatusCell.self,forCellReuseIdentifier: YHContractMainItemStatusCell.cellReuseIdentifier)
        return tableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData2()
        loadData()
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(animated)
        loadData()
    }
}

extension YHServiceCenterSecondViewController {
    func loadData2() {
        self.serviceCenterMainReqVM.getPersonInfoFillStep(params: ["orderId":orderId]) { success, error in
        }
    }
    
    func loadData() {
        self.serviceCenterMainReqVM.getContactStatus(params: ["orderId":orderId]) { success, error in
            self.homeTableView.reloadData()
        }
    }
    
    func setupUI() {
        gk_navTitle = "服务中心"
        gk_navBarAlpha = 1.0
        gk_navLineHidden = false
        
       
        
        view.addSubview(topBkg)
        topBkg.snp.makeConstraints { make in
            make.top.left.right.equalToSuperview()
            make.height.equalTo(216)
        }
        
        
        homeTableView.delegate = self
        homeTableView.dataSource = self
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    @objc func clickUnfoldView() {
        unfoldFlag = !unfoldFlag
        if unfoldFlag == true {
            UIView.animate(withDuration: 0.25) {
                self.downArrowImagev.transform = CGAffineTransform.identity
            }
        } else {
            UIView.animate(withDuration: 0.25) {
                self.downArrowImagev.transform = CGAffineTransform(rotationAngle: .pi)
            }
        }
        homeTableView.reloadSections(IndexSet(integer: 0), with: UITableView.RowAnimation.automatic)
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHServiceCenterSecondViewController : UITableViewDelegate,UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        if unfoldFlag == true {
            return self.serviceCenterMainReqVM.arrContactStausItmes.count
        }
        return 0
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return 40
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: 40))
        view.backgroundColor = .clear
        
        let lable = UILabel(frame: CGRect(x: 16, y: 0, width: 200, height: 40))
        lable.text = "身份申请"
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.textColor = .mainTextColor
        view.addSubview(lable)
        
        lable.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(kMargin)
        }
        
        
        view.addSubview(downArrowImagev)
        downArrowImagev.snp.makeConstraints { make in
            make.centerY.equalToSuperview()
            make.right.equalTo(-kMargin)
            make.width.height.equalTo(16)
        }
        
        let tap = UITapGestureRecognizer(target: self, action: #selector(clickUnfoldView))
        view.addGestureRecognizer(tap)
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return YHContractMainItemStatusCell.cellHeight
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let newCell = tableView.dequeueReusableCell(withClass: YHContractMainItemStatusCell.self)
        newCell.selectionStyle = .none
        
        newCell.dataModel = self.serviceCenterMainReqVM.arrContactStausItmes[indexPath.row]
        return newCell
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        
        let model =  self.serviceCenterMainReqVM.arrContactStausItmes[indexPath.row]
        
        
        
        if model.type == 1 {
            if self.serviceCenterMainReqVM.informationFillStepModel?.sweet_notify_status == 0 {
                self.showTipsAlert()
                return
            }
            
            let vc = YHInformationPerfectListVC()
            vc.orderId = orderId
            navigationController?.pushViewController(vc)
        } else if model.type == 2 {            
            let vc = YHMineCertificateEntryViewController()
            vc.orderId = orderId
            navigationController?.pushViewController(vc)
            
        } else if model.type == 3 {
            let vc = YHScoreDetailViewController()
            vc.orderId = orderId
            vc.model = serviceCenterMainReqVM.allInfoScoreModel
            navigationController?.pushViewController(vc)
        } else if model.type == 4 {
            let vc = YHMyDocumentsListViewController()
            vc.orderId = orderId
            vc.mobile = mobile ?? ""
            navigationController?.pushViewController(vc)
        } else if model.type == 5 {
            let vc = YHMySignatureListViewController()
            vc.orderId = orderId
            navigationController?.pushViewController(vc)
        } else if model.type == 6 {
            let vc = YHMineSchemeViewController()
            navigationController?.pushViewController(vc)
        }
        else {
            
        }
    }
}

private extension YHServiceCenterSecondViewController {
    func showTipsAlert() {
        YHInformationFillTipsAlertView.showCheckView { agree in
            if agree == true {
                printLog("点击了 确认 按钮")
                self.submitSweetNotify()
            } else {
                printLog("点击了 取消 按钮")
            }
        }
    }
    
    
    
    func submitSweetNotify() {
        let params = ["option":1,"order_id":orderId]
        serviceCenterMainReqVM.submitSweetNotifyOp(params: params as [String : Any]) { success, error in
            if success == true {
                YHInformationFillTipsAlertView.hideCheckView()
                self.loadData2()
                
                let vc = YHInformationPerfectListVC()
                vc.orderId = self.orderId
                self.navigationController?.pushViewController(vc)
            } else {
                YHHUD.flash(message: error?.errorMsg ?? "发生错误,请重试")
            }
        }
    }
}
