//
//  YHPrincipleCongratulationVC.swift
//  galaxy
//
//  Created by edy on 2024/5/6.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHPrincipleCongratulationVC: YHBaseViewController {

    lazy var titleLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("祝贺您", .font(UIFont.PFSC_M(ofSize: 24)),.foreground(UIColor.init(hex: 0xF07300)))
        let b: ASAttributedString = .init("，李先生", .font(UIFont.PFSC_M(ofSize: 24)),.foreground(UIColor.mainTextColor))
        label.attributed.text = a + b
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("您【与家人】申请的【优秀人才入境计划】", .font(UIFont.PFSC_R(ofSize: 16)),.foreground(UIColor.mainTextColor))
        let b: ASAttributedString = .init("已获得港府的甄选名额。", .font(UIFont.PFSC_R(ofSize: 16)),.foreground(UIColor.init(hex: 0xF07300)))
        let c: ASAttributedString = .init("请您于2023年6月25日前补充更多文件，即可等待获得港府的正式批准！", .font(UIFont.PFSC_R(ofSize: 16)),.foreground(UIColor.mainTextColor))
        label.attributed.text = a+b+c
        return label
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        gk_navTitle = "原则批"
        view.addSubview(titleLabel)
        view.addSubview(detailLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(k_Height_NavigationtBarAndStatuBar+24)
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.height.equalTo(34)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.equalTo(24)
            make.right.equalTo(-24)
        }
    }
    

}
