//
//  YHPrincipleWaitResultModel.swift
//  galaxy
//
//  Created by edy on 2024/8/7.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHPrincipleWaitItemType: Int {
    case none = 0
    case photo = 1    // 实时入境处身份申请进度
    case entry = 2    // 入境处已认收受理
    case profile = 3  // 申请资料已递交港府留档
}

class YHPrincipleWaitResultModel: SmartCodable {
    
    var lastQueryAt: String = ""
    var queryCount: Int = 0
    var fileNumberList: [YHFileNumberList] = []
    var resultImageList: [YHResultImageList] = []
    var applicant: YHApplicant = YHApplicant()
    var applicationFileNumberAttachment: String = ""
    
    // 自定义属性
    var isUnfold = false // 是否展开
    var type: YHPrincipleWaitItemType = .none
    var title: String = ""
    var subTitle: String = ""
  
    enum CodingKeys: String, CodingKey {
        case lastQueryAt = "last_query_at"
        case queryCount = "query_count"
        case fileNumberList = "file_number_list"
        case resultImageList = "result_image_list"
        case applicant
        case applicationFileNumberAttachment = "application_file_number_attachment"
    }
    
    required init() {
        
    }

    init(lastQueryAt: String, queryCount: Int, fileNumberList: [YHFileNumberList], resultImageList: [YHResultImageList], applicant: YHApplicant, applicationFileNumberAttachment: String) {
        self.lastQueryAt = lastQueryAt
        self.queryCount = queryCount
        self.fileNumberList = fileNumberList
        self.resultImageList = resultImageList
        self.applicant = applicant
        self.applicationFileNumberAttachment = applicationFileNumberAttachment
    }
    
    func copy() -> YHPrincipleWaitResultModel {
        return YHPrincipleWaitResultModel(lastQueryAt: lastQueryAt,
                                          queryCount: queryCount,
                                          fileNumberList: fileNumberList,
                                          resultImageList: resultImageList,
                                          applicant: applicant,
                                          applicationFileNumberAttachment: applicationFileNumberAttachment)
    }
}

// MARK: - Applicant
class YHApplicant: SmartCodable {
    var id: Int = 0
    var sex: Int = 0
    var userName: String = ""

    enum CodingKeys: String, CodingKey {
        case id, sex
        case userName = "user_name"
    }

    required init() {
        
    }
}

// MARK: - FileNumberList
class YHFileNumberList: SmartCodable {
    
    var applicationName: String = ""
    var fileNumber: String = ""

    enum CodingKeys: String, CodingKey {
        case applicationName = "application_name"
        case fileNumber = "file_number"
    }

    required init() {
        
    }
}

class YHResultImageList: SmartCodable {
    
    var applicationName: String = ""
    var logNumber: Int = 0
    var fileNumber: String = ""
    var image: String = ""

    enum CodingKeys: String, CodingKey {
        case applicationName = "application_name"
        case logNumber = "log_number"
        case fileNumber = "file_number"
        case image
    }

    required init() {
        
    }
}
