//
//  YHPrincipleCongratulationAlertView.swift
//  galaxy
//
//  Created by edy on 2024/8/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHPrincipleCongratulationAlertView: UIView {

    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var closeBtn:UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "update_close"), for: .normal)
        btn.addTarget(self, action: #selector(didCloseBtnClicked), for: .touchUpInside)
        return btn
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_B(ofSize: 24)
        label.textColor = UIColor.brandMainColor
        label.text = "祝贺获批!"
        return label
    }()
    
    lazy var detailLabel: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14.0)
        let a: ASAttributedString = .init("恭喜您申请的【优秀人才入境计划】", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("已获得港府的甄选名额！", .font(UIFont.PFSC_B(ofSize: 14)),.foreground(UIColor.brandMainColor))
        label.attributed.text = a+b
        return label
    }()
    
    lazy var bgImgView: UIImageView = {
        let view = UIImageView(image: UIImage(named: "principle_congratulation_bg"))
        let bottomView = UIImageView(image: UIImage(named: "principle_congratulation_alpha"))
        view.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.left.right.bottom.equalToSuperview()
            make.height.equalTo(58.0)
        }
        return view
    }()
    
    lazy var lookBtn: UIButton = {
        let button = UIButton()
        button.backgroundColor =  UIColor.brandMainColor
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 14)
        button.setTitle("查看详情", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.addTarget(self, action: #selector(didLookBtnClicked), for: .touchUpInside)
        return button
    }()
    
    static func alertView() -> YHPrincipleCongratulationAlertView {
        let view = YHPrincipleCongratulationAlertView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func didCloseBtnClicked() {
        self.dismiss()
    }
    
    @objc func didLookBtnClicked() {
        
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        self.addSubview(closeBtn)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(detailLabel)
        whiteContentView.addSubview(bgImgView)
        whiteContentView.addSubview(lookBtn)
        
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.top.equalTo(32)
            make.height.equalTo(34)
        }
        
        detailLabel.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.right.equalTo(-24)
            make.top.equalTo(titleLabel.snp.bottom).offset(20)
        }
        
        bgImgView.snp.makeConstraints { make in
            make.width.equalTo(245)
            make.height.equalTo(170)
            make.top.equalTo(detailLabel.snp.bottom).offset(20)
            make.centerX.equalToSuperview()
        }
        
        lookBtn.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-16)
            make.height.equalTo(45)
            make.top.equalTo(bgImgView.snp.bottom)
        }
        
        closeBtn.snp.makeConstraints { make in
            make.width.height.equalTo(24)
            make.top.equalTo(whiteContentView.snp.bottom).offset(24)
            make.centerX.equalTo(whiteContentView)
        }
    }
}
