//
//  YHPrinciplePhotoCell.swift
//  galaxy
//
//  Created by edy on 2024/8/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPrinciplePhotoListCell: UITableViewCell {

    static let cellReuseIdentifier = "YHPrinciplePhotoListCell"
    var itemModel:YHPrincipleWaitResultModel?
    var items: [YHResultImageList] = []
    var expandClick:((Bool)->())?
    
    lazy var iconImgView:UIImageView = {
        let view = UIImageView(image: UIImage(named: "custom_service_icon_right"))
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_R(ofSize: 15)
        label.textColor = UIColor.mainTextColor
        label.text = "申请资料已递交港府留档"
        return label
    }()
    
    lazy var whiteView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = 6.0
        view.clipsToBounds = true
        return view
    }()
    
    lazy var expandBtn:UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "custom_service_expand_0"), for: .normal)
        btn.addTarget(self, action: #selector(didExpandBtnClicked), for: .touchUpInside)
        btn.YH_clickEdgeInsets = UIEdgeInsets(top: 0, left: 40, bottom: 20, right: 40)
        return btn
    }()
    
    lazy var collectView = {
        let flowLayout = UICollectionViewFlowLayout()
        flowLayout.minimumLineSpacing = 0.0
        
        flowLayout.scrollDirection = .vertical
        let collectinoView = UICollectionView(frame: .zero, collectionViewLayout: flowLayout)
        collectinoView.contentInset = UIEdgeInsets(top: 0, left: 16, bottom: 0, right: 16)
        collectinoView.backgroundColor = UIColor.white
        collectinoView.register(YHPrinciplePhotoCollectCell.self, forCellWithReuseIdentifier:YHPrinciplePhotoCollectCell.cellReuseIdentifier)
        collectinoView.delegate = self
        collectinoView.dataSource = self
        collectinoView.backgroundColor = .clear
        collectinoView.isScrollEnabled = false
        return collectinoView
    }()
    
    lazy var timeLabel: UILabel = {
        let label = UILabel()
        label.font = UIFont.PFSC_M(ofSize: 13)
        label.textColor = UIColor(hex: 0x121A26, alpha: 0.3)
        label.numberOfLines = 0
        label.text = "最新更新时间：2024-04-19  19:50:12\n已累计为您查询 4 次"
        return label
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    @objc func didExpandBtnClicked() {
        guard let model = itemModel else { return }
        expandClick?(!model.isUnfold)
    }
    
    func updateModel(_ model:YHPrincipleWaitResultModel) {
        
        itemModel = model
        items.removeAll()
        items.append(contentsOf: model.resultImageList)
        whiteView.isHidden = !model.isUnfold
        let imgName = model.isUnfold ? "custom_service_expand_1" : "custom_service_expand_0"
        expandBtn.setImage(UIImage(named: imgName), for: .normal)
        expandBtn.isHidden = items.count <= 0
        timeLabel.text = "最新更新时间：\(model.lastQueryAt)\n已累计为您查询\(model.queryCount)次"
        
        if !model.isUnfold || items.count <= 0 {
            whiteView.removeSubviews()
            whiteView.snp.remakeConstraints { make in
                make.top.equalTo(titleLabel.snp.bottom).offset(0.0)
                make.height.equalTo(0.0)
                make.left.equalTo(20)
                make.right.equalTo(-20)
                make.bottom.equalTo(-32)
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
            return
        }
        
        whiteView.removeSubviews()
        whiteView.addSubview(collectView)
        whiteView.addSubview(timeLabel)
        whiteView.snp.remakeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(16.0)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.bottom.equalTo(-32)
        }
        
        let imgHeight = items.count == 1 ? 170.0 : 80.0
        let titleGap = items.count == 1 ?  16.0 : 12.0
        let titleHeight = 18.0
        let row = items.count/2 + items.count%2
        let totalHeight = Double(row) * (imgHeight + titleGap + titleHeight + 16.0)
        collectView.snp.remakeConstraints { make in
            make.top.equalTo(16.0)
            make.left.right.equalToSuperview()
            make.height.equalTo(totalHeight)
        }
        collectView.reloadData()
        
        timeLabel.snp.remakeConstraints { make in
            make.left.equalTo(16.0)
            make.right.equalTo(-16.0)
            make.top.equalTo(collectView.snp.bottom).offset(-10.0)
            make.bottom.equalTo(-16)
        }
        
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }

    
    func setupUI() {
        
        self.selectionStyle = .none
        self.contentView.backgroundColor = .clear
        self.backgroundColor = .clear
        contentView.addSubview(iconImgView)
        contentView.addSubview(titleLabel)
        contentView.addSubview(expandBtn)
        contentView.addSubview(whiteView)
        whiteView.addSubview(collectView)
        whiteView.addSubview(timeLabel)

        iconImgView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.width.height.equalTo(15.0)
            make.centerY.equalTo(titleLabel)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconImgView.snp.right).offset(6)
            make.right.equalTo(expandBtn.snp.left)
            make.top.equalTo(0)
            make.height.equalTo(20)
        }
        
        expandBtn.snp.makeConstraints { make in
            make.width.height.equalTo(20.0)
            make.centerY.equalTo(titleLabel)
            make.right.equalTo(-20.0)
        }
        
        whiteView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(0.0)
            make.height.equalTo(0.0)
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.bottom.equalTo(-32)
        }
        
        collectView.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.left.equalTo(16.0)
            make.right.equalTo(-16.0)
            make.top.equalTo(collectView.snp.bottom)
            make.height.equalTo(0.0)
        }
    }
}

extension YHPrinciplePhotoListCell: UICollectionViewDelegateFlowLayout, UICollectionViewDelegate, UICollectionViewDataSource {
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return items.count
    }
    
    func collectionView(_ collectionView: UICollectionView, layout collectionViewLayout: UICollectionViewLayout, sizeForItemAt indexPath: IndexPath) -> CGSize {
        
        let imgWidth = items.count == 1 ? KScreenWidth-36.0*2.0:  (KScreenWidth-36.0*2.0-15.0)/2.0
        let imgHeight = items.count == 1 ? 170.0 : 80.0
        let titleGap = items.count == 1 ?  16.0 : 12.0
        let titleHeight = 18.0
        return CGSizeMake(imgWidth, imgHeight + titleGap + titleHeight + 16.0)
    }
        
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: YHPrinciplePhotoCollectCell.cellReuseIdentifier, for: indexPath) as! YHPrinciplePhotoCollectCell
        cell.isSinglePhoto = items.count == 1
        if 0 <= indexPath.item, indexPath.item < items.count {
            let model = items[indexPath.item]
            cell.updateModel(model)
        }
        return cell
    }
        
    private func collectionView(collectionView: UICollectionView, didSelectItemAtIndexPath indexPath: NSIndexPath) {
        print("index is \(indexPath.row)")
    }
}
