//
//  YHPrincipleUploadFileCell.swift
//  galaxy
//
//  Created by edy on 2024/8/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPrincipleUploadFileCell: UITableViewCell {

    static let cellReuseIdentifier = "YHPrincipleUploadFileCell"

    static let height = 55.0
    var iconImgV: UIImageView!
    var titleLabel: UILabel!
    var timeLabel: UILabel!
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    func updateModel(_ str: String) {
        titleLabel.text = str
        timeLabel.text = "上传于2023.02.06"
    }
    
    func setupUI() {
        
        iconImgV = UIImageView(image: UIImage(named: "my_cer_type_pdf"))
        self.addSubview(iconImgV)
        
        titleLabel = UILabel()
        titleLabel.font = UIFont.PFSC_M(ofSize: 14)
        titleLabel.textColor = UIColor.mainTextColor
        titleLabel.text = "新公司在职证明.pdf"
        self.addSubview(titleLabel)
        
        timeLabel = UILabel()
        timeLabel.font = UIFont.PFSC_R(ofSize: 11)
        timeLabel.textColor = UIColor.labelTextColor2
        timeLabel.text = "上传于2024.12.12"
        self.addSubview(timeLabel)
        
        iconImgV.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31.0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.bottom.equalTo(self.snp.centerY).offset(-1)
            make.left.equalTo(iconImgV.snp.right).offset(18)
            make.right.equalTo(-16)
            make.height.equalTo(20)
        }
        
        timeLabel.snp.makeConstraints { make in
            make.top.equalTo(self.snp.centerY).offset(1)
            make.left.equalTo(iconImgV.snp.right).offset(18)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
    }
}
