//
//  YHPrincleViewModel.swift
//  galaxy
//
//  Created by edy on 2024/4/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHPrincleViewModel: YHBaseViewModel {
    
    var waitResultModel = YHPrincipleWaitResultModel()
    var envelopModel = YHPrincipleEnvelopeModel()
    var uploadDetailModel = YHPrincipleUploadDetailModel()
    
    func getPrincipleWaitReviewResult(params:[String : Any], callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getProfileList
        
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleWaitResultModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.waitResultModel = resultModel
                callback?(true, nil)
                
            } else {
                
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    func getEnvelopeInfo(orderId:Int, callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getReviewResult
        
        let params: [String : Any] = ["order_id": orderId]
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleEnvelopeModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.envelopModel = resultModel
                self.envelopModel = self.getEnvelopModel()
                callback?(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                self.envelopModel = self.getEnvelopModel()
                callback?(false, err)
            }
            
        } failBlock: { err in
            self.envelopModel = self.getEnvelopModel()
            callback?(false, err)
        }
    }
    
    func getPrincipleUploadDetail(orderId:Int, callback:((_ success: Bool,_ error:YHErrorModel?)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getUploadDetail
        
        let params: [String : Any] = ["order_id": orderId]
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHPrincipleUploadDetailModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    callback?(false, err)
                    return
                }
                self.uploadDetailModel = resultModel
                callback?(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callback?(false, err)
            }
            
        } failBlock: { err in
            callback?(false, err)
        }
    }
    
    func requestIsSendMail(orderId:Int, callback:((_ isSend: Bool)->())?) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Principle.getIsSendMail
        let params: [String : Any] = ["order_id": orderId]
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                if let isSend = json.data as? Bool {
                    callback?(isSend)
                } else {
                    callback?(false)
                }
                
            } else {
                callback?(false)
            }
            
        } failBlock: { err in
            callback?(false)
        }
    }
    
    func getEnvelopModel() -> YHPrincipleEnvelopeModel {
        let model = YHPrincipleEnvelopeModel()
        model.name = "黄金龙"
        model.sex = 1
        model.date = "2024-12-12"
        return model
    }
    
    func getTestModel() -> YHPrincipleWaitResultModel {
        
        var files: [YHFileNumberList] = []
        let m = YHFileNumberList()
        m.applicationName = "杜宇"
        m.fileNumber = "23412-AVAVS-SADFAS"
        let m2 = YHFileNumberList()
        m2.applicationName = "宇"
        m2.fileNumber = "23412-AVAVS-SADFAS"
        files.append(m)
        files.append(m2)

        var imgs: [YHResultImageList] = []
        let n = YHResultImageList()
        n.applicationName = "嘟嘟"
        let n1 = YHResultImageList()
        n1.applicationName = "嘟嘟"
        let n2 = YHResultImageList()
        n2.applicationName = "嘟嘟"
        imgs.append(n)
        imgs.append(n1)
        imgs.append(n2)

        let applicant = YHApplicant()
        applicant.userName = "哈哈哈"
        
        let model = YHPrincipleWaitResultModel(lastQueryAt: "2024-12-01 23:34:12",
                                               queryCount: 40,
                                               fileNumberList: files,
                                               resultImageList: imgs,
                                               applicant: applicant,
                                               applicationFileNumberAttachment: "你要死啊")
        return model
    }
}
