//
//  YHMyFileListNoneCell.swift
//  galaxy
//
//  Created by edy on 2024/7/5.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMyFileListNoneCell: UITableViewCell {

    static let cellReuseIdentifier = "YHMyFileListNoneCell"
    
    lazy var whiteContentView:UIView = {
        let view = UIView()
        view.backgroundColor = .white
        return view
    }()

    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        self.contentView.addSubview(self.whiteContentView)
        
        self.whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.bottom.equalToSuperview()
        }
        
        let grayView : UIView = UIView()
        grayView.layer.cornerRadius = 6.0
        grayView.clipsToBounds = true
        grayView.backgroundColor = UIColor(hex: 0xE5E9F2, alpha: 0.3)
        self.whiteContentView.addSubview(grayView)
        
        grayView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.height.equalTo(72)
        }
        
        let label = UILabel()
        label.text = "暂无待完善清单"
        label.font = UIFont.PFSC_R(ofSize: 12)
        label.textColor = UIColor.yhGreyColor
        
        grayView.addSubview(label)
        label.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
    }
}
