//
//  YHQuestionAndAnswerViewController.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/17.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
/*
 问题答疑列表
 */

class YHQuestionAndAnswerViewController: YHBaseViewController {
    
    private let certificateReqVM : YHCertificateViewModel = YHCertificateViewModel()
    
    private lazy var topBkg : UIView = {
        let imagV = UIImageView()
        imagV.image = UIImage(named: "service_center_head_bkg")
        imagV.contentMode = .scaleAspectFill
        return imagV
        
    }()
    
    var homeTableView: UITableView = {
        let tableView = UITableView(frame: .zero, style: .grouped)
        tableView.backgroundColor = .clear
        tableView.separatorStyle = .none
        tableView.showsHorizontalScrollIndicator = false
        tableView.showsVerticalScrollIndicator = false
        tableView.rowHeight = UITableView.automaticDimension
        tableView.register(YHQuestionAndAnswerCell.self,forCellReuseIdentifier: YHQuestionAndAnswerCell.cellReuseIdentifier)
        return tableView
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        setupUI()
        loadData()
    }
    
    //    override func viewWillAppear(_ animated: Bool) {
    //        super.viewWillAppear(animated)
    //
    //    }
}

extension YHQuestionAndAnswerViewController {
    func loadData() {
        if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
            let param = ["order_id":orderID,"node":"1","state":"1"]
            
            
            certificateReqVM.getQuestionAndAnserList(params: param) { success, error in
                if success == true {
                } else {
                    YHHUD.flash(message: error?.errorMsg ?? "请求出错")
                }
                
                self.homeTableView.reloadData()
            }
        } else {
            printLog("error : orderID 为空")
        }
    }
    
    func setupUI() {
        gk_navTitle = "问题答疑"
        gk_navBarAlpha = 0.5
        gk_navLineHidden = false
        gk_navBackgroundColor = .white
        
        
        view.addSubview(homeTableView)
        homeTableView.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(k_Height_NavigationtBarAndStatuBar)
            make.left.right.bottom.equalToSuperview()
        }
        homeTableView.delegate = self
        homeTableView.dataSource = self
        
        
        let foot = UIView()
        foot.frame = CGRect(x: 0, y: 0, width: KScreenWidth, height: 62)

        let label000 = UILabel()
        label000.text = "* 如以上问题无法帮助，请前往咨询联系或直接联系您的服务团队"
        label000.textColor = .labelTextColor2
        label000.font = UIFont.PFSC_R(ofSize: 12)
        label000.numberOfLines = 0
        label000.lineBreakMode = .byWordWrapping
        foot.addSubview(label000)
        
        label000.snp.makeConstraints { make in
            make.top.equalToSuperview().offset(28)
            make.left.equalToSuperview().offset(34)
            make.right.equalToSuperview().offset(-34)
            
            make.bottom.equalToSuperview()
        }
        
        homeTableView.tableFooterView = foot
        homeTableView.reloadData()
        homeTableView.layoutIfNeeded()
        
    }
}

// MARK: - UITableViewDelegate 和 UITableViewDataSource
extension YHQuestionAndAnswerViewController : UITableViewDelegate,UITableViewDataSource {
    func numberOfSections(in tableView: UITableView) -> Int {
        return certificateReqVM.arrQuestionAndAnswer.count
    }
    
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return 1
    }
    
    func tableView(_ tableView: UITableView, heightForHeaderInSection section: Int) -> CGFloat {
        return kMargin
    }
    
    func tableView(_ tableView: UITableView, viewForHeaderInSection section: Int) -> UIView? {
        let view = UIView(frame: CGRect(x: 0, y: 0, width: KScreenWidth, height: kMargin))
        return view
    }
    
    func tableView(_ tableView: UITableView, heightForFooterInSection section: Int) -> CGFloat {
        return 0
    }
    
    func tableView(_ tableView: UITableView, viewForFooterInSection section: Int) -> UIView? {
        return UIView()
    }
    
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        return UITableView.automaticDimension
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell0 = tableView.dequeueReusableCell(withClass: YHQuestionAndAnswerCell.self)
        cell0.selectionStyle = .none
        
        if indexPath.section < certificateReqVM.arrQuestionAndAnswer.count {
            cell0.dataModel = certificateReqVM.arrQuestionAndAnswer[indexPath.section]
        }
        return cell0
    }
    
    func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        printLog("点击了 tableView Cell \(indexPath.section)")
    }
}

