//
//  YHCertificateFilterButton.swift
//  galaxy
//
//  Created by edy on 2024/3/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHCertificateFilterButton: UIView {

    static let width = 37.0
    static let translucentWidth = 16.0
    var translucentImgView: UIImageView!
    var filterImgView: UIImageView!
    var filterButton: UIButton!
    var isSelect: Bool = false {
        didSet {
            let imgName = isSelect ? "my_cer_filter_select" : "my_cer_filter_unselect"
            filterImgView.image = UIImage(named: imgName)
        }
    }
    var clickBlock:((Bool)->())?

    static func filterBtn()-> YHCertificateFilterButton {
        let btn = YHCertificateFilterButton(frame: CGRect(x: 0, y: 0, width: Self.width, height: Self.width))
        return btn
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func createUI() {
        
        translucentImgView = UIImageView(image: UIImage(named: "my_cer_translucent"))
        filterImgView = UIImageView(image: UIImage(named: "my_cer_filter_unselect"))
        filterButton = UIButton()
        filterButton.addTarget(self, action: #selector(didFilterBtnClicked), for: .touchUpInside)
        self.addSubviews([translucentImgView, filterImgView, filterButton])
        
        translucentImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: Self.translucentWidth, height: 20))
            make.left.equalToSuperview()
            make.centerY.equalToSuperview()
        }
        filterImgView.snp.makeConstraints { make in
            make.size.equalTo(CGSize(width: 21, height: 21))
            make.left.equalTo(translucentImgView.snp.right)
            make.centerY.equalToSuperview()
        }
        filterButton.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
    }
    
    @objc func didFilterBtnClicked() {
        isSelect = true
        if let clickBlock = clickBlock {
            clickBlock(isSelect)
        }
    }
}
