//
//  YHDocListBottomView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/3/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDocListBottomView: UIView {
    static let viewH : CGFloat = 98.0
    

    typealias Block = (ClickButtonType,Bool) -> ()
    var block: Block?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        initView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var bottomButton : UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_M(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitle("下载", for: .normal)
        button.setTitleColor( UIColor(hex:0xffffff), for: .normal)
        button.layer.cornerRadius = kCornerRadius3
        button.clipsToBounds = true
        button.addTarget(self, action: #selector(clickDownloadBtn), for: .touchUpInside)
        return button
    }()
    
    lazy var checkButton : UIButton = {
        let button = UIButton(type: .custom)
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 15)
        button.contentHorizontalAlignment = .center
        button.setTitleColor(UIColor.mainTextColor, for: .normal)
        button.setImage(UIImage(named: "my_doc_check_btn_0"), for: .normal)
        button.setImage(UIImage(named: "my_doc_check_btn_1"), for: .selected)
        button.setTitle("全选", for: .normal)
        button.addTarget(self, action: #selector(clickCheckBtn), for: .touchUpInside)
        return button
    }()
    
    private lazy var titleLable : UILabel = {
        let lable0 = UILabel(text: "已选0条")
        lable0.textColor = UIColor(hex: 0xC0C0C0, alpha: 1.0)
        lable0.font = UIFont.PFSC_R(ofSize: 15)
        return lable0
    }()
    
    
    private lazy var line : UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    
    
    func updateNumber(allNumber : Int,selectedNumber : Int) {
        titleLable.text = "已选" + selectedNumber.string + "条"
        if allNumber == selectedNumber,selectedNumber > 0 {
            checkButton.isSelected = true
        } else {
            checkButton.isSelected = false
        }
    }
}

private extension YHDocListBottomView {
    func initView() {
        
        addSubview(line)
        line.snp.makeConstraints { make in
            make.left.right.top.equalToSuperview()
            make.height.equalTo(0.5)
        }

        addSubview(checkButton)
        checkButton.snp.makeConstraints { make in
            make.top.equalTo(21.5)
            make.left.equalTo(kMargin)
            make.width.equalTo(60)
            make.height.equalTo(30)
        }
        checkButton.iconInLeft(spacing: 5)
        
        addSubview(titleLable)
        titleLable.snp.makeConstraints { make in
            make.centerY.equalTo(checkButton)
            make.left.equalTo(checkButton.snp.right).offset(6)
            make.width.equalTo(60)
            make.height.equalTo(22)
        }
        
        addSubview(bottomButton)
        bottomButton.snp.makeConstraints { make in
            make.right.equalTo(-kMargin)
            make.centerY.equalTo(checkButton)
            make.height.equalTo(44)
            make.left.equalTo(titleLable.snp.right).offset(34)
        }
    }
    
    @objc func clickCheckBtn() {
        checkButton.isSelected = !checkButton.isSelected
        block?(.allChoice,checkButton.isSelected)
        
        if checkButton.isSelected == false {
            titleLable.text = "已选" + 0.string + "条"
        }
    }
    
    @objc func clickDownloadBtn() {
        block?(.downAllCheck,false)
    }
}
