//
//  YHDocumentMessageTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/3/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHDocumentMessageTableViewCell: UITableViewCell {
    typealias Block = (YHMyFileMethodType) -> ()
    var block: Block?
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var topLineView: UIView!
    var bottomView: UIView!
    var bottomCenterLineView: UIView!
    var bottomCenterLine1View: UIView!
    var bottomCenterLine2View: UIView!
    var fileImageView: UIImageView!
    var fileNameLabel: UILabel!
    var editButton: UIButton!
    var submitButton: UIButton!
    var lookButton: UIButton!
    var downLoadButton: UIButton!
    var dataSource: YHMyDocumentDetailModel? {
        didSet {
            updateAllViews()
        }
    }

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        let width = self.width/3 - 1
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            label.text = "文书稿件"
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(18)
            make.top.equalTo(16)
            make.height.equalTo(24)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 10)
            label.textColor = UIColor.labelTextColor2
            label.backgroundColor = UIColor.warnColor.withAlphaComponent(0.08)
            label.textAlignment = .left
            label.text = "已提交"
            label.layer.cornerRadius = kCornerRadius3
            label.masksToBounds = true
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.height.equalTo(18)
            make.left.equalTo(titleLabel.snp.right).offset(4)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
        
        topLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(topLineView)
        topLineView.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(18)
            make.height.equalTo(1)
            make.top.equalTo(52)
        }
        
        bottomView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomView)
        bottomView.snp.makeConstraints { make in
            make.right.left.equalToSuperview()
            make.height.equalTo(1)
            make.top.equalTo(123)
        }
        
        bottomCenterLineView = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomCenterLineView)
        bottomCenterLineView.snp.makeConstraints { make in
            make.centerX.equalToSuperview()
            make.width.equalTo(1)
            make.bottom.equalTo(-17.5)
            make.height.equalTo(16)
        }
        
        bottomCenterLine1View = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomCenterLine1View)
        bottomCenterLine1View.snp.makeConstraints { make in
            make.left.equalTo(width)
            make.width.equalTo(1)
            make.bottom.equalTo(-17.5)
            make.height.equalTo(16)
        }
        
        bottomCenterLine2View = {
            let view = UIView()
            view.backgroundColor = UIColor.separatorColor
            return view
        }()
        centerView.addSubview(bottomCenterLine2View)
        bottomCenterLine2View.snp.makeConstraints { make in
            make.right.equalTo(-width)
            make.width.equalTo(1)
            make.bottom.equalTo(-17.5)
            make.height.equalTo(16)
        }
        
        editButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("编辑", for: .normal)
            button.addTarget(self, action: #selector(editButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(editButton)
        editButton.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.right.equalTo(bottomCenterLine1View.snp.left)
        }
        
        submitButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("提交", for: .normal)
            button.addTarget(self, action: #selector(submitButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(submitButton)
        submitButton.snp.makeConstraints { make in
            make.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.left.equalTo(bottomCenterLine1View.snp.right)
            make.right.equalTo(bottomCenterLine2View.snp.left)
        }
        
        lookButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("查看", for: .normal)
            button.addTarget(self, action: #selector(lookButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(lookButton)
        lookButton.snp.makeConstraints { make in
            make.left.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.right.equalTo(bottomCenterLineView.snp.left)
        }
        
        downLoadButton = {
            let button = UIButton(type: .custom)
            button.setTitleColor(UIColor.brandMainColor, for: .normal)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.setTitle("下载", for: .normal)
            button.addTarget(self, action: #selector(downLoadButtonClick), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(downLoadButton)
        downLoadButton.snp.makeConstraints { make in
            make.right.bottom.equalToSuperview()
            make.top.equalTo(bottomView.snp.bottom)
            make.left.equalTo(bottomCenterLineView.snp.right)
        }
        
        fileImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "")
            return view
        }()
        centerView.addSubview(fileImageView)
        fileImageView.snp.makeConstraints { make in
            make.left.equalTo(24)
            make.centerY.equalToSuperview()
            make.width.height.equalTo(31)
        }
        
        fileNameLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            label.text = "雇主的推荐信(仅签字)华为科技有限公司.doc"
            return label
        }()
        centerView.addSubview(fileNameLabel)
        fileNameLabel.snp.makeConstraints { make in
            make.right.equalTo(-18)
            make.left.equalTo(67)
            make.height.equalTo(40)
            make.centerY.equalToSuperview()
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        if dataSource.prospectus.id == 0 {
            var statusTxt = ""
            var color : UIColor = .brandMainColor
            
            let status = dataSource.writing_document.status
            if status == 1 {
                statusTxt = " 不展示 "
                color = UIColor.brandMainColor
                lookButton.isHidden = true
                editButton.isHidden = false
                submitButton.isHidden = false
                bottomCenterLineView.isHidden = true
                bottomCenterLine1View.isHidden = false
                bottomCenterLine2View.isHidden = false
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLine2View.snp.right)
                }
            } else if status == 2 {
                statusTxt = " 待确认 "
                color = UIColor.brandMainColor
                lookButton.isHidden = true
                editButton.isHidden = false
                submitButton.isHidden = false
                bottomCenterLineView.isHidden = true
                bottomCenterLine1View.isHidden = false
                bottomCenterLine2View.isHidden = false
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLine2View.snp.right)
                }
            } else if status == 3 {
                statusTxt = " 已提交 "
                color = UIColor.warnColor
                lookButton.isHidden = false
                editButton.isHidden = true
                submitButton.isHidden = true
                bottomCenterLineView.isHidden = false
                bottomCenterLine1View.isHidden = true
                bottomCenterLine2View.isHidden = true
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLineView.snp.right)
                }
            } else if status == 4 {
                statusTxt = " 已提交 "
                color = UIColor.warnColor
                lookButton.isHidden = false
                editButton.isHidden = true
                submitButton.isHidden = true
                bottomCenterLineView.isHidden = false
                bottomCenterLine1View.isHidden = true
                bottomCenterLine2View.isHidden = true
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLineView.snp.right)
                }
            } else if status == 5 {
                statusTxt = " 已驳回 "
                color = UIColor.successColor
                lookButton.isHidden = false
                editButton.isHidden = true
                submitButton.isHidden = true
                bottomCenterLineView.isHidden = false
                bottomCenterLine1View.isHidden = true
                bottomCenterLine2View.isHidden = true
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLineView.snp.right)
                }
            } else if status == 6 {
                statusTxt = " 已定稿 "
                color = UIColor.labelTextColor2
                lookButton.isHidden = false
                editButton.isHidden = true
                submitButton.isHidden = true
                bottomCenterLineView.isHidden = false
                bottomCenterLine1View.isHidden = true
                bottomCenterLine2View.isHidden = true
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLineView.snp.right)
                }
            } else if status == 7 {
                statusTxt = " 已完成 "
                color = UIColor.labelTextColor2
                lookButton.isHidden = false
                editButton.isHidden = true
                submitButton.isHidden = true
                bottomCenterLineView.isHidden = false
                bottomCenterLine1View.isHidden = true
                bottomCenterLine2View.isHidden = true
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLineView.snp.right)
                }
            } else {
                statusTxt = " -- "
                color = UIColor.failColor
                lookButton.isHidden = false
                editButton.isHidden = true
                submitButton.isHidden = true
                bottomCenterLineView.isHidden = false
                bottomCenterLine1View.isHidden = true
                bottomCenterLine2View.isHidden = true
                downLoadButton.snp.remakeConstraints { make in
                    make.right.bottom.equalToSuperview()
                    make.top.equalTo(bottomView.snp.bottom)
                    make.left.equalTo(bottomCenterLineView.snp.right)
                }
            }
            
            subTitleLabel.text = statusTxt
            subTitleLabel.textColor = color
            subTitleLabel.backgroundColor = color.withAlphaComponent(0.08)
            fileNameLabel.text = dataSource.writing_document.name
            let suffix =  dataSource.writing_document.name.pathExtension.lowercased()
            var iconImgName = ""
            if suffix == "jpeg" {
                iconImgName = "my_cer_type_jpg"
            } else if suffix == "jpg" {
                iconImgName = "my_cer_type_jpg"
            } else if suffix == "png" {
                iconImgName = "my_cer_type_png"
            } else if suffix == "pdf" {
                iconImgName = "my_cer_type_pdf"
            } else if suffix == "doc" || suffix == "docx" {
                iconImgName = "my_cer_type_word"
            } else if suffix == "ppt" || suffix == "pptx" {
                iconImgName = "my_cer_type_ppt"
            } else if suffix == "bmp" {
                iconImgName = "my_cer_type_bmp"
            } else if suffix == "tiff" {
                iconImgName = "my_cer_type_tiff"
            }
            fileImageView.image = UIImage(named: iconImgName)
        } else {
            // 赴港计划书逻辑
            
        }
    }

    @objc func editButtonClick() {
        if let block = block {
            block(.edit)
        }
    }
    
    @objc func lookButtonClick() {
        if let block = block {
            block(.look)
        }
    }
    
    @objc func submitButtonClick() {
        if let block = block {
            block(.submit)
        }
    }
    
    @objc func downLoadButtonClick() {
        if let block = block {
            block(.downLoad)
        }
    }
}

