//
//  YHDocumentPromptTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/3/28.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHDocumentPromptTableViewCell: UITableViewCell {
    var centerView: UIImageView!
    var promptImageView: UIImageView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var type: Int = 0 {
        didSet {
            updatePrompt()
        }
    }

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIImageView()
            view.image = UIImage(named: "document_prompt_bg")
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(8)
            make.bottom.equalTo(-8)
        }
        
        promptImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "tips_icon")
            return view
        }()
        centerView.addSubview(promptImageView)
        promptImageView.snp.makeConstraints { make in
            make.width.height.equalTo(14)
            make.left.equalTo(16)
            make.top.equalTo(16)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 12)
            label.textColor = UIColor.brandMainColor
            label.text = "温馨提示："
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.top.equalTo(16)
            make.height.equalTo(17)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.labelTextColor2
            label.numberOfLines = 0
            let a: ASAttributedString = .init("您可以", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.subTextColor2))
            let aa: ASAttributedString = .init("先下载原件，然后打印去签字/盖章，最后扫描签字/盖章件上传", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.brandMainColor))
            label.attributed.text = a + aa
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(15)
            make.right.equalTo(-15)
            make.top.equalTo(38.5)
        }
        
    }
    
    func updatePrompt() {
        // 1-代理委托书，2-受养人声明，3-工作经验补充表，4-声明书，5-人才清单声明书，6-个人陈述书，7-推荐信，8-组织架构图

        if type == 7 || type == 8 {
            let a: ASAttributedString = .init("您可以", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.subTextColor2))
            let aa: ASAttributedString = .init("转发给需签署的人签字，若需要盖章，则先确认文书是否已签完，然后下载打印去盖章，扫描签章件上传", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.brandMainColor))
            subTitleLabel.attributed.text = a + aa
        } else if type == 2 {
            let a: ASAttributedString = .init("您可以", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.subTextColor2))
            let aa: ASAttributedString = .init("先下载原件，然后打印去签字/盖章，最后扫描签字/盖章件上传", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.brandMainColor))
            subTitleLabel.attributed.text = a + aa
        } else {
            let a: ASAttributedString = .init("您可以", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.subTextColor2))
            let aa: ASAttributedString = .init("直接电子签署文书，或上传已签章件", .font(UIFont.PFSC_R(ofSize: 12)),.foreground(UIColor.brandMainColor))
            subTitleLabel.attributed.text = a + aa
        }
    }

}


