//
//  YHSchemeHeadScoreItemView.swift
//  galaxy
//
//  Created by EDY on 2024/3/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHSchemeHeadScoreItemView: UIView {
    var titleLabel: UILabel!
    var itemImageView: UIImageView!
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(15)
            make.top.bottom.equalToSuperview()
        }
        
        itemImageView = {
            let view = UIImageView()
            view.image = UIImage(named: "scheme_head_score_item")
            return view
        }()
        addSubview(itemImageView)
        itemImageView.snp.makeConstraints { make in
            make.width.height.equalTo(3)
            make.centerY.left.equalToSuperview()
        }
    }
    
    func setContent(_ message: String, _ light: String,_ addtionStr: String) {
        if message.contains("名校加分") {
            
            let a: ASAttributedString = .init("学历", .font(UIFont.PFSC_M(ofSize: 14)),.foreground(UIColor.mainTextColor))
            
            let aa: ASAttributedString = .init(NSAttributedString(string: light), .font(UIFont.PFSC_M(ofSize: 14)),.foreground(UIColor.warnColor))
            
            
            let b: ASAttributedString = .init("分，名校加分", .font(UIFont.PFSC_M(ofSize: 14)),.foreground(UIColor.mainTextColor))
            
            let bb: ASAttributedString = .init(NSAttributedString(string: addtionStr), .font(UIFont.PFSC_M(ofSize: 14)),.foreground(UIColor.warnColor))
            
            let bbb: ASAttributedString = .init("分", .font(UIFont.PFSC_M(ofSize: 14)),.foreground(UIColor.mainTextColor))
            
            titleLabel.attributed.text = a + aa + b + bb + bbb
        } else {
            let newString: NSAttributedString = message.highlighted(keyWords: light, highlightColor: UIColor.warnColor)
            titleLabel.attributedText = newString
        }
    }
}
