//
//  YHSchemeTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/3/19.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHSchemeTableViewCell: UITableViewCell {
    typealias SchemeBlock = (_ index: Int) -> ()
    var schemeBlock: SchemeBlock?
    var centerView: UIView!
    var lineImageView: UIImageView!
    var titleView: UIView!
    var titleLabel: UILabel!
    var titleButton: UIButton!
    var mainMessageLabel: UILabel!
    var subMessageLabel: UILabel!
    
    var dataSource: YHScemeItemModel?{
        didSet {
            updateAllViews()
        }
    }
    
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        // Configure the view for the selected state
    }
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        contentView.backgroundColor = UIColor(hex: 0x070E33)
        backgroundColor = UIColor(hex: 0x070E33)
        
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(8)
            make.right.equalTo(-8)
            make.top.bottom.equalToSuperview()
        }
        
        lineImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "scheme_line_image")
            return imageView
        }()
        contentView.addSubview(lineImageView)
        lineImageView.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.top.equalTo(0)
            make.height.equalTo(1)
            make.right.equalTo(-28)
        }
        
        titleView = {
            let view = UIView()
            view.backgroundColor = UIColor(hex: 0xd48638)
            return view
        }()
        contentView.addSubview(titleView)
        titleView.snp.makeConstraints { make in
            make.left.equalTo(28)
            make.top.equalTo(29)
            make.height.equalTo(16.5)
            make.width.equalTo(3.5)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.centerY.equalTo(titleView.snp.centerY)
            make.left.equalTo(titleView.snp.right).offset(4)
            make.height.equalTo(24)
            make.width.equalTo(150)
        }
        
        titleButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_M(ofSize: 12)
            button.backgroundColor = UIColor(hex: 0xd48638).withAlphaComponent(0.08)
            button.contentHorizontalAlignment = .center
            button.setTitle("资料清单", for: .normal)
            button.setImage(UIImage(named: "scheme_button_icon"), for: .normal)
            button.setTitleColor(UIColor(hex:0xd48638), for: .normal)
            button.layer.cornerRadius = kCornerRadius3
            button.clipsToBounds = true
            button.addTarget(self, action: #selector(goNext), for: .touchUpInside)
            return button
        }()
        centerView.addSubview(titleButton)
        titleButton.snp.makeConstraints { make in
            make.centerY.equalTo(titleView.snp.centerY)
            make.right.equalTo(-28)
            make.height.equalTo(27)
            make.width.equalTo(76)
        }
        
        mainMessageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.mainTextColor
            label.numberOfLines = 0
            return label
        }()
        
       
        
        centerView.addSubview(mainMessageLabel)
        mainMessageLabel.snp.makeConstraints { make in
            make.top.equalTo(69)
            make.left.equalTo(28)
            make.right.equalTo(-28)
        }
        
        subMessageLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 14)
            label.textColor = UIColor.labelTextColor2
            label.numberOfLines = 0
            return label
        }()
        centerView.addSubview(subMessageLabel)
        subMessageLabel.snp.makeConstraints { make in
            make.top.equalTo(mainMessageLabel.snp.bottom).offset(12)
            make.left.equalTo(28)
            make.right.equalTo(-28)
        }
        
    }
    
    func updateAllViews() {
        guard let model = dataSource else { return }
        if model.buttonTitle.count == 0 {
            titleButton.isHidden = true
        }
        titleLabel.text = model.title
        titleButton.setTitle(model.buttonTitle, for: .normal)
        titleButton.iconInRight(with: 2)
        let newString: NSAttributedString = model.mainMessage.highlighted(keyWords: model.lightMessage, highlightColor: UIColor(hex: 0xd48638))
        mainMessageLabel.attributedText = newString
        
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineSpacing = 4 // 设置行间距
        let attributes: [NSAttributedString.Key: Any] = [
            .paragraphStyle: paragraphStyle,
            .font: UIFont.PFSC_R(ofSize: 14)
        ]
        
        let attributedString = NSAttributedString(string: model.subMessage, attributes: attributes)
        subMessageLabel.attributedText = attributedString
    }
    
    @objc func goNext() {
        if  let title = titleButton.titleLabel?.text {
            if title.contains("资料清单") {
                if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
                    let vc = YHMineCertificateEntryViewController()
                    vc.orderId = orderID as? Int ?? 0
                    UIViewController.current?.navigationController?.pushViewController(vc)
                } else {
                    YHHUD.flash(message: "订单号为空")
                }
                
            } else if title.contains("文书写作") {
                
                if let orderID = UserDefaults.standard.value(forKey: "orderIdForPreview") {
                    let vc = YHMyDocumentsListViewController()
                    vc.orderId = orderID as? Int ?? 0
                    UIViewController.current?.navigationController?.pushViewController(vc)
                } else {
                    YHHUD.flash(message: "订单号为空")
                }
            }
        }
    }
}
