//
//  YHMySignatureListTableViewCell.swift
//  galaxy
//
//  Created by EDY on 2024/3/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySignatureListTableViewCell: UITableViewCell {
    var centerView: UIView!
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var dataSource: YHMySignatureModel? {
        didSet {
            updateAllViews()
        }
    }

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }

    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        selectionStyle = .none
        setupUI()
    }
    
    func setupUI() {
        backgroundColor = .clear
        centerView = {
            let view = UIView()
            view.backgroundColor = .white
            view.layer.cornerRadius = kCornerRadius6
            return view
        }()
        contentView.addSubview(centerView)
        centerView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(7)
            make.bottom.equalTo(-7)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 17)
            label.textColor = UIColor.mainTextColor
            return label
        }()
        centerView.addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_R(ofSize: 12)
            label.textColor = UIColor.labelTextColor2
            label.textAlignment = .right
            return label
        }()
        centerView.addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.top.bottom.equalToSuperview()
            make.right.equalTo(-21)
        }
        
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        titleLabel.text = dataSource.doc_name
        subTitleLabel.text = "\(dataSource.doc_type)"
    }

}
