//
//  YHMySignatureListViewModel.swift
//  galaxy
//
//  Created by EDY on 2024/3/8.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHMySignatureListViewModel: YHBaseViewModel {

    var mainModel: YHMySignatureListModel?
    
    override init() {
        super.init()
    }
    
    func requestSignatureList(_ orderId: String, callBackBlock:@escaping (_ success: Bool, _ error: YHErrorModel?)->()) {
        let params: [String : Any] = ["order_id": orderId]
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Signature.list
        let _ = YHNetRequest.getRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHMySignatureListModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false,nil)
                    return
                }
                self.mainModel = result
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false, err)
        }
    }
}
