//
//  YHFamilyMemberViewModel.swift
//  galaxy
//
//  Created by edy on 2024/3/2.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import Alamofire

class YHFamilyMemberViewModel : YHBaseViewModel{

    var mainModel: YHFamilyMember = YHFamilyMember()
    
    var saveInfoSilentBlock:(()->())?
    
    func getIDCardDataSource(_ isShowPrompt: Bool) -> [YHSectionItemModel] {
        let item = YHItemModel(id: .id5, isNeed: true, title: "身份证", isUserKeyBoard: false, prompts: "请输入", message: nil, isShowPrompts: isShowPrompt)
        let section = YHSectionItemModel(title: "中国身份证(选填)", models: [item])
        let item1 = YHItemModel(id: .id6, isNeed: true, title: "港澳通行证(选填)", isUserKeyBoard: false, prompts: "请输入", message: nil, isShowPrompts: isShowPrompt)
        let section1 = YHSectionItemModel(title: "中国身份证(选填)", models: [item1])
        if mainModel.isNeedHandleHKPassPort() {
            return [section, section1]
        } else {
            return [section]
        }
    }
    
    func updateModel(_ item: YHItemModel) {
        guard let type = item.id else { return }
        
        if item.id == .id8 {
            mainModel.certificates.cnIdentityCard.number = item.message ?? ""
            
        } else if item.id == .id9 {
            mainModel.certificates.cnIdentityCard.issueAt = item.message ?? ""
            
        } else if item.id == .id10 {
            mainModel.certificates.cnIdentityCard.issueDateStartAt = item.message ?? ""
        } else if item.id == .id11 {
            mainModel.certificates.cnIdentityCard.issueDateEndAt = item.message ?? ""
            
        } else if item.id == .id12 {
            mainModel.certificates.hkMacaoPass.number = item.message ?? ""
        } else if item.id == .id13 {
            mainModel.certificates.hkMacaoPass.issueAt = item.message ?? ""
        } else if item.id == .id14 {
            mainModel.certificates.hkMacaoPass.issueDateStartAt = item.message ?? ""
        } else if item.id == .id15 {
            mainModel.certificates.hkMacaoPass.issueDateEndAt = item.message ?? ""
        } else if item.id == .id16 {
//            mainModel.certificates.passport.passportType = item.value?.first ?? ""
        } else if item.id == .id17 {
            mainModel.certificates.passport.number = item.message ?? ""
        } else if item.id == .id18 {
            mainModel.certificates.passport.issueAt = item.message ?? ""
        } else if item.id == .id19 {
            mainModel.certificates.passport.issueDateStartAt = item.message ?? ""
        } else if item.id == .id20 {
            mainModel.certificates.passport.issueDateEndAt = item.message ?? ""
        }
        if let saveInfoSilentBlock = saveInfoSilentBlock {
            saveInfoSilentBlock()
        }
    }
    
    // 更新身份证
    func updateModel(_ model: YHCNIDCardModel) {
        if model.name.count != 0 {
            mainModel.subsetName = model.name
        }
        if model.birth.count != 0 {
            if mainModel.relationType != .child {
                // 孩子生日设置大于18岁后必须设置为不能随行 导致证件上传和证件信息页面隐藏 会产生异常
                mainModel.birthday = model.birth
            }
        }
        if model.gender.count != 0 {
            if model.gender == "女" {
                mainModel.setMale(false)
            } else {
                mainModel.setMale(true)
            }
        }
        if model.term_begins.count != 0 {
            mainModel.certificates.cnIdentityCard.issueDateStartAt = model.term_begins
        }
        if model.end_of_term.count != 0 {
            mainModel.certificates.cnIdentityCard.issueDateEndAt = model.end_of_term
        }
        if model.issuing_authority.count != 0 {
            mainModel.certificates.cnIdentityCard.issueAt = model.issuing_authority
        }
        if model.card_num.count != 0 {
            mainModel.certificates.cnIdentityCard.number = model.card_num
        }
        if let saveInfoSilentBlock = saveInfoSilentBlock {
            saveInfoSilentBlock()
        }
    }
    
    // 更新港澳通行证
    func updateModel(_ model: YHHKIDCardModel) {
        if model.name.count != 0 {
            mainModel.subsetName = model.name
        }
        if model.birth.count != 0 {
            if mainModel.relationType != .child {
                // 孩子生日设置大于18岁后必须设置为不能随行 导致证件上传和证件信息页面隐藏 会产生异常
                mainModel.birthday = model.birth
            }
        }
        if model.gender.count != 0 {
            if model.gender == "女" {
                mainModel.setMale(false)
            } else {
                mainModel.setMale(true)
            }
        }
        if model.term_begins.count != 0 {
            mainModel.certificates.hkMacaoPass.issueDateStartAt = model.term_begins
        }
        if model.end_of_term.count != 0 {
            mainModel.certificates.hkMacaoPass.issueDateEndAt = model.end_of_term
        }
        if model.issuing_authority.count != 0 {
            mainModel.certificates.hkMacaoPass.issueAt = model.issuing_authority
        }
        if model.card_num.count != 0 {
            mainModel.certificates.hkMacaoPass.number = model.card_num
        }
        if let saveInfoSilentBlock = saveInfoSilentBlock {
            saveInfoSilentBlock()
        }
    }
    
    func updateModel(_ type: YHCardType, isFront: Bool, url: String) {
        switch type {
        case .identity:
            if isFront {
                mainModel.certificates.cnIdentityCard.imgFront = url
            } else {
                mainModel.certificates.cnIdentityCard.imgBack = url
            }
        case .passport:
            if isFront {
                mainModel.certificates.hkMacaoPass.imgFront = url
            } else {
                mainModel.certificates.hkMacaoPass.imgBack = url
            }
        }
        if let saveInfoSilentBlock = saveInfoSilentBlock {
            saveInfoSilentBlock()
        }
    }
    
    func requestCnIDCardMessage(_ url: String, isBack: Int, callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OCR.cn
        let params: [String : Any] = ["url": url,
                                      "is_back": isBack]
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHCNIDCardModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false, nil)
                    return
                }
                self.updateModel(result)
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    func requestHkIDCardMessage(_ url: String, isBack: Int, callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curOssURL() + YHAllApiName.OCR.hk
        let params: [String : Any] = ["url": url,
                                      "is_back": isBack]
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            if json.code == 200 {
                let dic = json.data
                guard let result = YHHKIDCardModel.deserialize(from: dic as? Dictionary) else {
                    callBackBlock(false, nil)
                    return
                }
                self.updateModel(result)
                callBackBlock(true, nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code), errorMsg: json.msg)
                callBackBlock(false, error)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
}
