//
//  YHFormTitleCell.swift
//  galaxy
//
//  Created by edy on 2024/1/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHFormItemTitleCell: UITableViewCell {

    static let cellReuseIdentifier = "YHFormItemTitleCell"
    private let horizonalGap = 18.0

    let editTag = 9527
    let cancelTag = 9528
    
    var rightClickBlock:((YHFormTitleItemEditType)->Void)?
    
    // isNeedWrap 副标题是否需要换行
    func setTitleAndSubTitle(title: String? = "", subTitle: String? = "", isNeedWrap:Bool = false) {
        
        let titleAttributes: [NSAttributedString.Key: Any] = [
            .font: UIFont.PFSC_M(ofSize: 17),
            .foregroundColor: UIColor.mainTextColor
        ]
        let subTitleAttributes: [NSAttributedString.Key: Any] = [
            .font: UIFont.PFSC_R(ofSize: 12),
            .foregroundColor: UIColor.labelTextColor2
        ]
        
        let attrStr = NSMutableAttributedString(string:"", attributes: titleAttributes)
    
        if let title = title, !title.isEmpty {
            let titleAttrStr = NSMutableAttributedString(string:title, attributes:titleAttributes)
            attrStr.append(titleAttrStr)
        }
        // 副标题是否需要换行
        if isNeedWrap {
            let warpAttrStr = NSMutableAttributedString(string:"\n", attributes:titleAttributes)
            attrStr.append(warpAttrStr)
        }
        
        if let subTitle = subTitle, !subTitle.isEmpty {
            let titleAttrStr = NSMutableAttributedString(string:subTitle, attributes:subTitleAttributes)
            attrStr.append(titleAttrStr)
        }
        titleLabel.attributedText = attrStr
    }

    private lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = .mainTextColor
        label.textAlignment = .left
        label.numberOfLines = 0
        label.font = UIFont.PFSC_M(ofSize: 17)
        return label
    }()
    
    lazy var cancelButton: UIButton = {
        
        let btn = UIButton()
        btn.setTitle("取消操作".local, for: .normal)
        btn.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        btn.setTitleColor(.brandMainColor, for: .normal)
        btn.tag = cancelTag
        btn.addTarget(self, action: #selector(didClickOperatorBtn(btn:)), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    lazy var editButton: UIButton = {
        let btn = UIButton()
        btn.setImage(UIImage(named: "form_edit"), for: .normal)
        btn.tag = editTag
        btn.addTarget(self, action: #selector(didClickOperatorBtn(btn:)), for: .touchUpInside)
        btn.isHidden = true
        return btn
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white
        
        contentView.addSubview(titleLabel)
        contentView.addSubview(editButton)
        contentView.addSubview(cancelButton)

        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(16)
            make.right.equalToSuperview().offset(-horizonalGap)
            make.top.equalToSuperview().offset(16)
            make.bottom.equalToSuperview().offset(-16)
        }
        
        editButton.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(24, 24))
            make.top.equalTo(titleLabel).offset(0)
            make.right.equalToSuperview().offset(-18)
        }
        
        cancelButton.snp.makeConstraints { make in
            make.size.equalTo(CGSizeMake(92, 40))
            make.centerY.equalTo(editButton)
            make.right.equalToSuperview()
        }
    }
    
    func showEditType(type: YHFormTitleItemEditType) {
        
        var titleMaxRight = -(horizonalGap)
        switch type {
            case .none:
                cancelButton.isHidden = true
                editButton.isHidden = true
            case .canEdit:
                cancelButton.isHidden = true
                editButton.isHidden = false
                titleMaxRight = -(horizonalGap+24.0+5.0)
            case .canCancel:
                cancelButton.isHidden = false
                editButton.isHidden = true
                titleMaxRight = -(horizonalGap+92.0+5.0)
         }
        titleLabel.snp.updateConstraints { make in
            make.right.equalToSuperview().offset(titleMaxRight)
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    @objc func didClickOperatorBtn(btn:UIButton) {
        
        if let clickBlock = rightClickBlock {
            if btn.tag == editTag {
                clickBlock(.canEdit)
                
            } else if btn.tag == cancelTag {
                clickBlock(.canCancel)
            }
        }
    }
    
}
