//
//  YHItemModel.swift
//  galaxy
//
//  Created by EDY on 2024/1/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

enum YHItemSelectType: Int {
    case normal = 0
    case address = 1
    case time = 2
    case image = 3
    case id = 4
    case country = 5
    case sex = 6
    case marry = 7
    case constellation = 8
    case school = 9
    case degree = 10
}

enum YHItemID: Int {
    case id1 = 0 //国籍 国家
    case id2 = 1 // 现居住地址 国家
    case id3 = 2 // 现居住地址 省市区
    case id4 = 3 // 现居住地址 详细地址
    case id5 = 4 // 通行证 是否
    case id6 = 5 // 中国身份证 上传
    case id7 = 6 // 港澳通行证 上传
    case id8 = 7 // 中国身份证 身份证号码
    case id9 = 8 // 中国身份证 签发地
    case id10 = 9 // 中国身份证 签发日期
    case id11 = 10 // 中国身份证 届满日期
    case id12 = 11 // 港澳通行证 身份证号码
    case id13 = 12 // 港澳通行证 签发地
    case id14 = 13 // 港澳通行证 签发日期
    case id15 = 14 // 港澳通行证 届满日期
    case id16 = 15 // 护照 类型
    case id17 = 16 // 护照 身份证号码
    case id18 = 17 // 护照 签发地
    case id19 = 18 // 护照 签发日期
    case id20 = 19 // 护照 届满日期
    case id21 = 20 // 主申请人信息 姓名
    case id22 = 21 // 主申请人信息 曾用名
    case id23 = 22 // 主申请人信息 婚前姓氏
    case id24 = 23 // 主申请人信息 出生日期
    case id25 = 24 // 主申请人信息 出生国家/地区
    case id26 = 25 // 主申请人信息 出生城市
    case id27 = 26 // 主申请人信息 性别
    case id28 = 27 // 主申请人信息 婚姻状况
    case id29 = 28 // 主申请人信息 手机号码
    case id30 = 29 // 主申请人信息 电子邮箱
    case id31 = 30 // 主申请人信息 香港身份证是否办理过是/否
    case id32 = 31 // 现居住地址 海外地址
    case id33 = 32 // 是否海外居住一年以上
    case id34 = 33 // 主申请人信息 出生城市国外
    case id35 = 34 // 香港ID号码
}


struct YHItemModel {
    var id: YHItemID?
    var isNeed: Bool?
    var title: String?
    var isUserKeyBoard: Bool?
    var prompts: String?
    var message: String?
    var leftButtonString: String?
    var rightButtonString: String?
    var type: YHItemSelectType?
    var value: [String]?
    var isShowPrompts: Bool?
    var alertMessage: String?
    
    init(id: YHItemID? = nil, isNeed: Bool? = nil, title: String? = nil, isUserKeyBoard: Bool? = nil, prompts: String? = nil, message: String? = nil, leftButtonString: String? = nil, rightButtonString: String? = nil, type: YHItemSelectType? = nil, value: [String]? = nil, isShowPrompts: Bool? = nil, alertMessage: String? = nil) {
        self.id = id
        self.isNeed = isNeed
        self.title = title
        self.isUserKeyBoard = isUserKeyBoard
        self.prompts = prompts
        self.message = message
        self.leftButtonString = leftButtonString
        self.rightButtonString = rightButtonString
        self.type = type
        self.value = value
        self.isShowPrompts = isShowPrompts
        self.alertMessage = alertMessage
    }
}

struct YHSectionItemModel {
    var title: String?
    var models: [YHItemModel]?
    
    init(title: String? = nil, models: [YHItemModel]? = nil) {
        self.title = title
        self.models = models
    }
}

