//
//  YHOtherInfoFillViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/18.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHOtherInfoFillViewModel: YHBaseViewModel {
    var otherInfoFillData : YHOtherInfoFillModel?
}

extension YHOtherInfoFillViewModel {
    
    //获取其他资料信息
    func getOtherInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.otherInfoFillApi
        let _ = YHNetRequest.getRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            
            if json.code == 200 {
                let dic = json.data
                guard let resultModel = YHOtherInfoFillModel.deserialize(dict: dic as? [AnyHashable : Any]) else {
                    callBackBlock(false,nil)
                    return
                }
                
                if resultModel.residences.isEmpty {
                    resultModel.residences.append(Residence())
                }
                
                self.otherInfoFillData = resultModel
                
                handleData()
                
                //根据返回值 组装 真实的数据
                callBackBlock(true,nil)
                
            } else {
                let err : YHErrorModel = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //保存其他资料信息
    func saveOtherInfo( params:[String : Any],callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Order.updateOtherInfoApi
        let _ = YHNetRequest.postRequest(url: strUrl,params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard self != nil else { return }
            printLog("model 是 ==> \(json)")
            //根据返回值 组装 真实的数据
            
            if json.code == 200 {
                callBackBlock(true,nil)
            } else {
                let error : YHErrorModel = YHErrorModel(errorCode:Int32(json.code),errorMsg: json.msg)
                callBackBlock(false,error)
            }
            
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
}


extension YHOtherInfoFillViewModel {
    func handleData() {
        if let language = self.otherInfoFillData?.language_detail {
            if language.level > 0 {
                let target = String(language.level)
                for(_,item) in YHConstantArrayData.arrLanguage.enumerated() {
                    
                    if target == item["id"] {
                        language.levelDes = item["title"] ?? ""
                        break
                    }
                }
            }
        }
        
        if let profession = self.otherInfoFillData?.profession {
            if profession.option > 0 {
                let target = String(profession.option)
                for(_,item) in YHConstantArrayData.arrSkill.enumerated() {
                    
                    if target == item["value"] {
                        profession.optionDes = item["title"] ?? ""
                        break
                    }
                }
            }
        }
    }
}
