//
//  YHWorkExampleMessageView.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkExampleMessageView: UIView {
    typealias ExampleBlock = (_ message: String) -> ()
    typealias BackBlock = () -> ()
    var exampleBlock: ExampleBlock?
    var backBlock: BackBlock?
    var backButton: UIButton!
    var titleLabel: UILabel!
    var tableView: UITableView!
    var dataSource: [String]?{
        didSet {
            updateView()
        }
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        
        backButton = {
            let button = UIButton(type: .custom)
            button.setBackgroundImage(UIImage(named: "work_example_back"), for: .normal)
            button.addTarget(self, action: #selector(back), for: .touchUpInside)
            return button
        }()
        addSubview(backButton)
        backButton.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.top.equalTo(20)
            make.height.width.equalTo(16)
        }
        
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 16)
            label.text = "业务支援及人力资源"
            label.textAlignment = .left
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalTo(backButton.snp.right).offset(6)
            make.centerY.equalTo(backButton.snp.centerY)
            make.right.equalTo(-16)
            make.height.equalTo(23)
        }
        
        tableView = {
            let tableView = UITableView(frame:.zero, style:.plain)
            if #available(iOS 11.0, *) {
                tableView.contentInsetAdjustmentBehavior = .never
            }
            tableView.backgroundColor = .clear
            tableView.separatorStyle = .none
            tableView.delegate = self
            tableView.dataSource = self
            tableView.register(cellWithClass: YHWorkExampleMessageTableViewCell.self)
            return tableView
        }()
        addSubview(tableView)
        tableView.snp.makeConstraints { make in
            make.top.equalTo(50)
            make.left.right.bottom.equalToSuperview()
        }
    }
    
    func updateView() {
        tableView.reloadData()
    }
    
    @objc func exampleClick() {
        if let block = exampleBlock {
            block("")
        }
    }
    
    @objc func back() {
        if let block = backBlock {
            block()
        }
    }
}

extension YHWorkExampleMessageView: UITableViewDelegate, UITableViewDataSource {
    func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return dataSource?.count ?? 0
    }
    
    func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCell(withClass: YHWorkExampleMessageTableViewCell.self)
        cell.titleLabel.text = "范例\(indexPath.row + 1)"
        cell.dataSource = dataSource?[indexPath.row]
        cell.messageBlock = { [weak self] message in
            if let block = self?.exampleBlock {
                block(message)
            }
        }
        return cell
    }
    
    func tableView(_ tableView: UITableView, heightForRowAt indexPath: IndexPath) -> CGFloat {
        
        let text = dataSource?[indexPath.row] // 要显示的文本内容
        let font = UIFont.PFSC_R(ofSize: 14) // 字体大小
        let maxWidth = KScreenWidth - 74 // 最大宽度限制
        
        // 创建NSAttributedString对象并设置属性
        let attributes = [NSAttributedString.Key.font : font] as [NSAttributedString.Key : Any]
        _ = NSMutableAttributedString(string: text ?? "", attributes: attributes)
         
        // 根据指定的最大宽度和字体大小计算文本的高度
        let size = (text! as NSString).boundingRect(with: CGSize(width: maxWidth, height: .greatestFiniteMagnitude), options: .usesLineFragmentOrigin, attributes: attributes, context: nil).size
        
//        if size.height < 311 {
//            return CGFloat(size.height + 87)
//        } else {
//            return CGFloat(385)
//        }
        return CGFloat(size.height + 87)
    }
}

