//
//  YHWorkIntroductionItemView.swift
//  galaxy
//
//  Created by EDY on 2024/2/20.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHWorkIntroductionItemView: UIView {
    typealias ItemBlock = (_ model: YHWorkExperienceProjectModel) -> ()
    var clickBlock: ItemBlock?
    var deleteBlock: ItemBlock?
    var titleLabel: UILabel!
    var subTitleLabel: UILabel!
    var nextStepImageView: UIImageView!
    var deleteButton: UIButton!
    var centerButton: UIButton!
    
    var dataSource: YHWorkExperienceProjectModel? {
        didSet {
            updateAllViews()
        }
    }
    override init(frame: CGRect) {
        super.init(frame: frame)
        backgroundColor = .white
        setUpView()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setUpView() {
        titleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 14)
            label.textAlignment = .left
            label.textColor = UIColor.mainTextColor
            return label
        }()
        addSubview(titleLabel)
        titleLabel.snp.makeConstraints { make in
            make.left.equalToSuperview()
            make.top.equalTo(16)
            make.right.equalTo(-30)
            make.height.equalTo(20)
        }
        
        subTitleLabel = {
            let label = UILabel()
            label.font = UIFont.PFSC_M(ofSize: 12)
            label.textAlignment = .left
            label.textColor = UIColor.subTextColor
            return label
        }()
        addSubview(subTitleLabel)
        subTitleLabel.snp.makeConstraints { make in
            make.left.right.equalToSuperview()
            make.height.equalTo(20)
            make.top.equalTo(40)
        }
        
        nextStepImageView = {
            let imageView = UIImageView()
            imageView.image = UIImage(named: "form_right_arrow")
            return imageView
        }()
        addSubview(nextStepImageView)
        nextStepImageView.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.centerY.equalToSuperview()
            make.height.width.equalTo(20)
        }
        
        centerButton = {
            let button = UIButton(type: .custom)
            button.addTarget(self, action: #selector(centerClick), for: .touchUpInside)
            return button
        }()
        addSubview(centerButton)
        centerButton.snp.makeConstraints { make in
            make.right.top.bottom.equalToSuperview()
            make.left.equalTo(112)
        }
        
        deleteButton = {
            let button = UIButton(type: .custom)
            button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
            button.contentHorizontalAlignment = .center
            button.setTitle("删除", for: .normal)
            button.setTitleColor( UIColor.failColor, for: .normal)
            button.addTarget(self, action: #selector(deleteClick), for: .touchUpInside)
            button.isHidden = true
            return button
        }()
        addSubview(deleteButton)
        deleteButton.snp.makeConstraints { make in
            make.right.equalToSuperview()
            make.height.equalTo(20)
            make.width.equalTo(28)
            make.centerY.equalTo(titleLabel.snp.centerY)
        }
    }
    
    func updateAllViews() {
        guard let dataSource = dataSource else { return }
        titleLabel.text = dataSource.project_name
        subTitleLabel.text = "\(dataSource.project_start_time ?? "")" + " ～ " + "\(dataSource.project_end_time ?? "")"
    }
    
    
    @objc func centerClick() {
        if let block = clickBlock {
            block(self.dataSource ?? YHWorkExperienceProjectModel())
        }
    }
    
    @objc func deleteClick() {
        if let block = deleteBlock {
            block(self.dataSource ?? YHWorkExperienceProjectModel())
        }
    }
    
    func isShowDelete(isShow: Bool) {
        if isShow {
            nextStepImageView.isHidden = true
            deleteButton.isHidden = false
        } else {
            nextStepImageView.isHidden = false
            deleteButton.isHidden = true
        }
    }
}
