//
//  YHInformationFillTipsCell.swift
//  galaxy
//
//  Created by davidhuangA on 2024/1/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHInformationFillTipsCell: UITableViewCell {
    static let cellReuseIdentifier = "YHInformationFillTipsCell"
    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }

    override func setSelected(_ selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)

        // Configure the view for the selected state
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}

extension YHInformationFillTipsCell {
    func setupUI() {
        let holdView = UIView()
        holdView.backgroundColor = .clear
        
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        
        contentView.addSubview(holdView)
        
        holdView.snp.makeConstraints { make in
            make.top.bottom.equalToSuperview()
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        //添加元素
        let lable0 = UILabel(text: "      您好！欢迎来到香港优才申请系统，请按照实际情况填写。")
        lable0.font = UIFont.PFSC_R(ofSize: 14)
        lable0.textColor = UIColor.mainTextColor
        lable0.numberOfLines = 0
        lable0.lineBreakMode = .byWordWrapping
        
        holdView.addSubview(lable0)
        lable0.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.right.equalToSuperview()
        }
        
        
        let lable1 = UILabel(text: "      1. 如您填写途中想离开系统，记得点击保存，在您有空闲的时间再继续进行填写；")
        lable1.font = UIFont.PFSC_R(ofSize: 14)
        lable1.textColor = UIColor.mainTextColor
        lable1.numberOfLines = 0
        lable1.lineBreakMode = .byWordWrapping
        let a: ASAttributedString = .init("      1. 如您填写途中想离开系统，", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        let b: ASAttributedString = .init("记得点击保存", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.brandMainColor))
        let c: ASAttributedString = .init("，在您有空闲的时间再继续进行填写；", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        lable1.attributed.text = a + b + c
        
        holdView.addSubview(lable1)
        lable1.snp.makeConstraints { make in
            make.top.equalTo(lable0.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
        }
        
        let lable2 = UILabel(text: "      2. 此次填写将花费您30-40分钟，系统将根据您所填写的信息，形成详细资料清单，一起为香港身份起航吧~")
        lable2.font =  UIFont.PFSC_R(ofSize: 14)
        lable2.textColor = UIColor.mainTextColor
        lable2.numberOfLines = 0
        lable2.lineBreakMode = .byWordWrapping
        
        let aa: ASAttributedString = .init("      2. 此次填写将花费您", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        let bb: ASAttributedString = .init("30-40分钟", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.brandMainColor))
        let cc: ASAttributedString = .init("，系统将根据您所填写的信息，形成详细资料清单，一起为香港身份起航吧~", .font(UIFont.PFSC_R(ofSize: 14)),.foreground(UIColor.mainTextColor))
        lable2.attributed.text = aa + bb + cc
        
        
        holdView.addSubview(lable2)
        lable2.snp.makeConstraints { make in
            make.top.equalTo(lable1.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
        }
        
        let holdView2 = UIView()
        holdView2.backgroundColor = UIColor.contentBkgColor
        holdView2.layer.cornerRadius = kCornerRadius6
        holdView2.clipsToBounds = true
        holdView.addSubview(holdView2)
        holdView2.snp.makeConstraints { make in
            make.top.equalTo(lable2.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
        }
        
        
        let view0 = UIView()
        view0.backgroundColor = UIColor.brandMainColor
        holdView2.addSubview(view0)
        view0.snp.makeConstraints { make in
            make.top.equalTo(15.5)
            make.left.equalToSuperview()
            make.width.equalTo(4)
            make.height.equalTo(14)
            
        }
        
        
        let lable3 = UILabel(text: "准备材料：")
        lable3.font =  UIFont.PFSC_M(ofSize: 14)
        lable3.textColor = UIColor.mainTextColor
        holdView2.addSubview(lable3)
        lable3.snp.makeConstraints { make in
            make.centerY.equalTo(view0)
            make.left.equalTo(view0.snp.right).offset(12)
            make.height.equalTo(20)
            make.right.equalTo(-16)
        }
        
        
        
        
        
        let imageV0 = UIImageView()
        imageV0.image = UIImage(named: "right_gou")
        imageV0.contentMode = .scaleAspectFill
        holdView2.addSubview(imageV0)
        imageV0.snp.makeConstraints { make in
            make.top.equalTo(lable3.snp.bottom).offset(16)
            make.left.equalTo(lable3.snp.left)
            make.width.height.equalTo(12)
        }
        
        let lable4 = UILabel(text: "身份证正反面照片（外国国籍准备护照）")
        lable4.font =  UIFont.PFSC_R(ofSize: 14)
        lable4.textColor = UIColor.mainTextColor
        holdView2.addSubview(lable4)
        lable4.snp.makeConstraints { make in
            make.centerY.equalTo(imageV0)
            make.left.equalTo(imageV0.snp.right).offset(8)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        let imageV1 = UIImageView()
        imageV1.image = UIImage(named: "right_gou")
        imageV1.contentMode = .scaleAspectFill
        holdView2.addSubview(imageV1)
        imageV1.snp.makeConstraints { make in
            make.top.equalTo(imageV0.snp.bottom).offset(12.5)
            make.left.equalTo(imageV0.snp.left)
            make.width.height.equalTo(12)
        }
        
        let lable5 = UILabel(text: "护照（如有）")
        lable5.font =  UIFont.PFSC_R(ofSize: 14)
        lable5.textColor = UIColor.mainTextColor
        holdView2.addSubview(lable5)
        lable5.snp.makeConstraints { make in
            make.centerY.equalTo(imageV1)
            make.left.equalTo(imageV1.snp.right).offset(8)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        
        let imageV2 = UIImageView()
        imageV2.image = UIImage(named: "right_gou")
        imageV2.contentMode = .scaleAspectFill
        holdView2.addSubview(imageV2)
        imageV2.snp.makeConstraints { make in
            make.top.equalTo(imageV1.snp.bottom).offset(12.5)
            make.left.equalTo(lable3.snp.left)
            make.width.height.equalTo(12)
        }
        
        let lable6 = UILabel(text: "港澳通行证正反面照片（如有）")
        lable6.font =  UIFont.PFSC_R(ofSize: 14)
        lable6.textColor = UIColor.mainTextColor
        holdView2.addSubview(lable6)
        lable6.snp.makeConstraints { make in
            make.centerY.equalTo(imageV2)
            make.left.equalTo(imageV2.snp.right).offset(8)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        
        let imageV3 = UIImageView()
        imageV3.image = UIImage(named: "right_gou")
        imageV3.contentMode = .scaleAspectFill
        holdView2.addSubview(imageV3)
        imageV3.snp.makeConstraints { make in
            make.top.equalTo(imageV2.snp.bottom).offset(12.5)
            make.left.equalTo(lable3.snp.left)
            make.width.height.equalTo(12)
        }
        
        let lable7 = UILabel(text: "简历/工作总结")
        lable7.font =  UIFont.PFSC_R(ofSize: 14)
        lable7.textColor = UIColor.mainTextColor
        holdView2.addSubview(lable7)
        lable7.snp.makeConstraints { make in
            make.centerY.equalTo(imageV3)
            make.left.equalTo(imageV3.snp.right).offset(8)
            make.height.equalTo(17)
            make.right.equalToSuperview()
            make.bottom.equalToSuperview().offset(-24)
        }
        
        
        let holdView3 = UIView()
        holdView3.backgroundColor = UIColor.clear
        holdView3.layer.cornerRadius = kCornerRadius6
        holdView3.clipsToBounds = true
        holdView3.layer.borderWidth = 1
        holdView3.layer.borderColor = UIColor(hexString: "#E4EEFF")?.cgColor
        holdView.addSubview(holdView3)
        holdView3.snp.makeConstraints { make in
            make.top.equalTo(holdView2.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.bottom.equalToSuperview().offset(-8)
            make.height.equalTo(120)
        }
        
        let tImageV : UIImageView = UIImageView(image: UIImage(named: "entry_bkg"))
        tImageV.contentMode = .scaleAspectFill
        holdView3.addSubview(tImageV)
        tImageV.snp.makeConstraints { make in
            make.edges.equalTo(0)
        }
        
        
        let imageV4 = UIImageView()
        imageV4.image = UIImage(named: "tips_icon")
        imageV4.contentMode = .scaleAspectFill
        holdView3.addSubview(imageV4)
        imageV4.snp.makeConstraints { make in
            make.top.equalTo(14)
            make.left.equalTo(16)
            make.width.height.equalTo(14)
        }
        
        
        let lable8 = UILabel(text: "温馨提示：")
        lable8.font = UIFont.PFSC_M(ofSize: 12)
        lable8.textColor = UIColor.brandMainColor
        holdView3.addSubview(lable8)
        lable8.snp.makeConstraints { make in
            make.centerY.equalTo(imageV4)
            make.left.equalTo(imageV4.snp.right).offset(8)
            make.height.equalTo(17)
            make.right.equalToSuperview()
        }
        
        
        let lable9 = UILabel(text: "请确认您所上传的资料真实有效，避免因递交资料存在问题给您造成不便。")
        lable9.numberOfLines = 0
        lable9.lineBreakMode = .byWordWrapping
        lable9.font = UIFont.PFSC_R(ofSize: 12)
        lable9.textColor = UIColor.brandMainColor
        holdView3.addSubview(lable9)
        lable9.snp.makeConstraints { make in
            make.top.equalTo(lable8.snp.bottom).offset(7)
            make.left.equalTo(imageV4.snp.left)
            make.right.equalToSuperview().offset(-16)
        }
        
        let lable10 = UILabel(text: "* 申请过程中有任何疑问，请随时联系专属服务群内的专业文案老师为您解答护航。")
        lable10.numberOfLines = 0
        lable10.lineBreakMode = .byWordWrapping
        lable10.font = UIFont.PFSC_R(ofSize: 12)
        lable10.textColor = UIColor.labelTextColor2
        holdView3.addSubview(lable10)
        lable10.snp.makeConstraints { make in
            make.top.equalTo(lable9.snp.bottom).offset(7)
            make.left.equalTo(lable9.snp.left)
            make.right.equalToSuperview().offset(-16)
        }
        
        holdView3.layoutIfNeeded()
        let imageV44 = UIImageView()
        imageV44.frame = holdView3.bounds
        imageV44.image = UIImage(named: "tips_cell_bkg")
        imageV44.contentMode = .scaleAspectFill
        imageV44.layer.zPosition = -1
        holdView3.addSubview(imageV44)
    }
}
