//
//  YHJsApi.swift
//  dsbridgedemo
//
//  Created by du on 2018/9/7.
//  Copyright © 2018年 杜文. All rights reserved.
//

import Foundation
import UIKit

typealias JSCallback = (String, Bool)->Void
typealias JSDicCallback = ([String : Any],Bool)->Void

class YHJsApi: NSObject {
    weak var delegate : YHBaseViewController? = nil
}

extension YHJsApi {
    //展示pics
    @objc func showPicsSyn(_ dicPics:[String : Any]) {
        //dsBridge.call("showPicsSyn",{pics:["123","456"], curIndex:1})
        if dicPics.isEmpty == false {
            let curIndex : Int = dicPics["curIndex"] as? Int ?? -1
            let arrPics : [String] = dicPics["pics"] as? [String] ?? []
            
            if curIndex > -1,arrPics.count > 0 {
                DispatchQueue.main.async {
                    YHPictureReviewManager.shared.showNetWorkPicturs(curIndex: curIndex, arrPicturs: arrPics)
                }
            }
        }
    }
    
    //设置app导航栏隐藏、显示
    @objc func setAppNavigation(_ tag : Any) {
        let tmp : Bool = tag as? Bool ?? false
        DispatchQueue.main.async {
            if let delegate = self.delegate as? YHH5WebViewVC {
                delegate.setAppNavigation(tmp)
            }
            
        }
    }
    
    //保存图片到本地
    @objc func saveLocalPictureSyn(_ picUrl: String) {
        DispatchQueue.main.async {
            
            if let delegate = self.delegate as? YHH5WebViewVC {
                delegate.saveLocalPictureSyn(picUrl)
            }
        }
    }
}
