//
//  YHValidateCodeInputView.swift
//  galaxy
//
//  Created by edy on 2023/12/26.
//

import UIKit


// 单个输入框组件
class YHValidateCodeComponentView : UIView {
    
    lazy var bgView : UIView = {
        let bgView = UIView()
        bgView.backgroundColor = UIColor(white: 1, alpha: 0.3)
        bgView.layer.cornerRadius = 4
        bgView.clipsToBounds = true
    
        return bgView
    }()
    
    lazy var textField : UITextField = {
        let textField = UITextField()
        textField.font = UIFont.systemFont(ofSize: 20)
        textField.textColor = UIColor.white
        textField.tintColor = UIColor.black
        textField.tag = 999
        textField.text = "*"
        return textField
    }()
    
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        
        bgView.addSubview(textField)
        self.addSubview(bgView)
        
        bgView.snp.makeConstraints { make in
            make.edges.equalTo(self)
        }
        textField.snp.makeConstraints { make in
            make.top.equalTo(self).offset(5)
            make.bottom.equalTo(self).offset(-5)
            make.width.equalTo(15)
            make.center.equalTo(self)
        }
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
}



class YHValidateCodeInputView: UIView {

    let baseTag = 9527
    // 小输入框个数
    var count:Int = 0
    // 小输入框宽度
    var inputWidth = 40.0
    // 小输入框长度
    var inputHeight = 40.0
    // 小输入框间距
    var gap = 8.0
    
    override init(frame: CGRect) {
        super.init(frame: frame)
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    convenience init(count:Int, inputWith:Double, inputHeight:Double, gap:Double) {
        self.init(frame: CGRectZero)
        self.count = count
        self.inputWidth = inputWith
        self.inputHeight = inputHeight
        self.gap = gap
        self.setupUI()
    }
//    static func createInputView(count:Int) -> YHValidateCodeInputView {
//        let view =  YHValidateCodeInputView()
//        view.count = count;
//        view.setupUI()
//        return view
//    }
    
    func setupUI() {
       
        // 输入框个数是否为偶数
            let isEven = (count % 2 == 0)
            for index in 1...count {
                
               let inputView = YHValidateCodeComponentView(frame: CGRectZero)
               inputView.tag = baseTag + index
               self.addSubview(inputView)
                
               // 小组件右边距离父视图中轴线间距
                var rightMargin = 0.0;
                if (isEven) { // 输入框个数为偶数
                    let middle = count/2
                    if (index <= middle) {
                        rightMargin = -(Double(middle-index)*(gap+inputWidth) + gap/2.0)
                    } else {
                        rightMargin = Double(index-middle-1)*(gap+inputWidth) + gap/2.0+inputWidth
                    }
                    print(rightMargin)
                    inputView.snp.makeConstraints { make in
                        make.size.equalTo(CGSize(width: inputWidth, height: inputHeight))
                        make.centerY.equalTo(self)
                        make.right.equalTo(self.snp.centerX).offset(rightMargin)
                    }
                    
                } else { // // 输入框个数为奇数
                    let middle:Int = count/2 + 1
                    if (index < middle) {
                        rightMargin = -(Double(middle-index-1)*(gap+inputWidth) + inputWidth/2.0+gap)
                    } else if (index > middle)  {
                        rightMargin = (Double(index-middle-1)*(gap+inputWidth) + inputWidth*3/2.0+gap)
                    }
                    print(rightMargin)
                    inputView.snp.makeConstraints { make in
                        make.size.equalTo(CGSize(width: inputWidth, height: inputHeight))
                        make.centerY.equalTo(self)
                        if (index == middle) {
                            make.centerX.equalTo(self)
                        } else {
                            make.right.equalTo(self.snp.centerX).offset(rightMargin)
                        }
                    }
                }
            }
        }
    
    func interactive() {
        
        for index in 1...count {
            let component = self.viewWithTag(baseTag+index) as! YHValidateCodeComponentView
            _ = component.viewWithTag(999) as! UITextField
        }
    }
    
     
}
