//
//  YHMsgListModel.swift
//  galaxy
//
//  Created by edy on 2024/4/15.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable

enum YHMessageType: Int {
    case none = 0
    case infoFill = 1   // 资料填写
    case cerUpload = 2  // 证件上传
    case draft = 3      // 文书定稿
    case fileSign = 4   // 文件签字
    case infoSubmit = 5 // 资料递交
}

class YHMessageInfoModel: SmartCodable {
    var unreadCount: Int = 0
    var lastMessage: String = ""
    var lastMessageTime: Int = 0
    var type: Int = 0
        
    required init() {
        
    }

    enum CodingKeys: String, CodingKey {
        case unreadCount = "unread_count"
        case lastMessage = "last_message"
        case lastMessageTime = "last_message_time"
        case type = "type"
    }
    
    func getTitle() -> String {
        if type == YHMessageType.infoFill.rawValue {
            return "资料填写"
            
        } else if type == YHMessageType.cerUpload.rawValue {
            return "证件上传"
            
        } else if type == YHMessageType.draft.rawValue {
            return "文书定稿"
            
        } else if type == YHMessageType.fileSign.rawValue {
            return "文件签字"
            
        } else if type == YHMessageType.infoSubmit.rawValue {
            return "资料递交"
        }
        return ""
    }
}

class YHMsgListModel: SmartCodable {
    var information: YHMessageInfoModel = YHMessageInfoModel()
    var certificate: YHMessageInfoModel = YHMessageInfoModel()
    var draft: YHMessageInfoModel = YHMessageInfoModel()
    var signature: YHMessageInfoModel = YHMessageInfoModel()
    var dataSubmission: YHMessageInfoModel = YHMessageInfoModel()
    
    required init() {
        self.information.type = YHMessageType.infoFill.rawValue
        self.certificate.type = YHMessageType.cerUpload.rawValue
        self.draft.type = YHMessageType.draft.rawValue
        self.signature.type = YHMessageType.fileSign.rawValue
        self.dataSubmission.type = YHMessageType.infoSubmit.rawValue
    }
    
    enum CodingKeys: String, CodingKey {
        case information, certificate, draft, signature
        case dataSubmission = "data_submission"
    }
}

class YHDetailMessageModel: SmartCodable {
    
    var id: String = ""
    var title: String = ""
    var content: String = ""
    var time: Int = 0
    var isRead: Bool = false
    var orderId: String = ""
    var url: String = ""
    
    required init() {
        
    }
    
    enum CodingKeys: String, CodingKey {
        case id, title, content, time, url
        case isRead = "is_read"
        case orderId = "order_id"
    }
}
