//
//  YHUatHelperViewModel.swift
//  galaxy
//
//  Created by david on 2024/7/23.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import Foundation
import HandyJSON


class YHUatModel2 : HandyJSON {
    var op : Int = -1       //"op": 1, //1-可见  2-不可见  3-新界面
    required init() {
    }
}


class YHUatModel : HandyJSON {
    /*
     默认展示
     1、我的-我的名片、 true
     2、我的-积分中心、true
     3、我的-我的测评码、true
     4、我的-银河湾、true
     5、我的-我的活动、true
     6、我的-关于我们、true

     默认不展示
     7、服务-订单搜索、false
     8、更新-强制更新弹窗、true
     9、更新-建议更新弹窗、false
     */
    var module_number : String = ""
    var result : Int = 0 //命中结果 0-未找到该规则，走默认逻辑 1-未命中，2-命中
    var show_config : YHUatModel2?
    
    required init() {
    }
}

class YHUatListModel : HandyJSON {
    var list : [YHUatModel] = []
    
    required init() {
    }
}

class YHUatHelperViewModel : YHBaseViewModel {
    var dataList : YHUatListModel?
}

// MARK: - 共有方法
extension YHUatHelperViewModel {
    //请求灰度功能列表配置
    func getUatList(callBackBlock:@escaping (_ success: Bool, _ error:YHErrorModel?)->()) {
        
        if !YHLoginManager.shared.isLogin() {
            printLog("非登录状态")
            return
        }
        
        let params: [String] = ["1", "2","3", "4","5","6","9"]
        var strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.Uat.uatListApi
        for (index,item) in params.enumerated() {
            if index == 0 {
                strUrl = strUrl + "?module_numbers=" + item
            } else {
                strUrl = strUrl + "&module_numbers=" + item
            }
        }
        
        let _ = YHNetRequest.getRequest(url: strUrl) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            let dic = json.data
            guard let resultModel = YHUatListModel.deserialize(from: dic as? Dictionary) else {
                callBackBlock(false,nil)
                return
            }
            self.dataList = resultModel
            
            
            
            callBackBlock(true,nil)
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
}


// MARK: - 私有方法
private extension YHUatHelperViewModel {
    
}
