//
//  UIDevice-Extension.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/11.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit
extension UIDevice {
    
    // MARK: - 屏幕size
    static let kScreenSize : CGRect = UIScreen.main.bounds
    
    // MARK: - 屏幕宽度
    static let kScreenW : CGFloat = UIScreen.main.bounds.width
    
    // MARK: - 屏幕高度
    static let kScreenH : CGFloat = UIScreen.main.bounds.height
    
    // MARK: - iOS系统版本号
    static let kSystemVersion : String = UIDevice.current.systemVersion
    
    
    
    
    // MARK: - 顶部安全区高度
    static func bs_safeDistanceTop() -> CGFloat {
        if #available(iOS 13.0, *) {
            let scene = UIApplication.shared.connectedScenes.first
            guard let windowScene = scene as? UIWindowScene else { return 0 }
            guard let window = windowScene.windows.first else { return 0 }
            return window.safeAreaInsets.top
        }
        //        else if #available(iOS 11.0, *) {
        //            guard let window = UIApplication.shared.windows.first else { return 0 }
        //            return window.safeAreaInsets.top
        //        }
        return 0;
    }
    
    // MARK: - 底部安全区高度
    static func bs_safeDistanceBottom() -> CGFloat {
        if #available(iOS 13.0, *) {
            let scene = UIApplication.shared.connectedScenes.first
            guard let windowScene = scene as? UIWindowScene else { return 0 }
            guard let window = windowScene.windows.first else { return 0 }
            return window.safeAreaInsets.bottom
        }
        //        else if #available(iOS 11.0, *) {
        //            guard let window = UIApplication.shared.windows.first else { return 0 }
        //            return window.safeAreaInsets.bottom
        //        }
        return 0;
    }
    
    // MARK: - 顶部状态栏高度（包括安全区）
    static func bs_statusBarHeight() -> CGFloat {
        var statusBarHeight: CGFloat = 0
        if #available(iOS 13.0, *) {
            let scene = UIApplication.shared.connectedScenes.first
            guard let windowScene = scene as? UIWindowScene else { return 0 }
            guard let statusBarManager = windowScene.statusBarManager else { return 0 }
            statusBarHeight = statusBarManager.statusBarFrame.height
        }
        //        else {
        //            statusBarHeight = UIApplication.shared.statusBarFrame.height
        //        }
        return statusBarHeight
    }
    
    // MARK: - 导航栏高度
    static func bs_navigationBarHeight() -> CGFloat {
        return 44.0
    }
    
    // MARK: - 状态栏+导航栏的高度
    static func bs_navigationFullHeight() -> CGFloat {
        return UIDevice.bs_statusBarHeight() + UIDevice.bs_navigationBarHeight()
    }
    
    // MARK: - 底部导航栏高度
    static func bs_tabBarHeight() -> CGFloat {
        return 49.0
    }
    
    // MARK: - 底部导航栏高度（包括安全区）
    static func bs_tabBarFullHeight() -> CGFloat {
        return UIDevice.bs_tabBarHeight() + UIDevice.bs_safeDistanceBottom()
    }
    
    
    
    
    
    // MARK: - 版本号
    static func appVersion() -> String {
        let infoDictionary = Bundle.main.infoDictionary
        if let infoDictionary = infoDictionary {
            let appVersion = infoDictionary["CFBundleShortVersionString"]
            return appVersion as! String
        }
        return " "
    }
    
    // MARK: - 内部编译版本号
    static func appBuild() -> String {
        let infoDictionary = Bundle.main.infoDictionary
        if let infoDictionary = infoDictionary {
            let appBuild = infoDictionary["CFBundleVersion"]
            return appBuild as! String
        }
        return " "
    }
    
}


