//
//  BsConstant.swift
//  BaiSiSMApp
//
//  Created by davidhuang on 2022/10/19.
//  Copyright © 2022 www.davidhuang.com. All rights reserved.
//

import UIKit

// MARK: - 工程中的 常量定义

let APP_NAME = Bundle.main.infoDictionary!["CFBundleName"] as! String

/// 打印
///
/// - Parameters:
///   - message: 打印内容
///   - file: 所在文件
///   - method: 所在方法
///   - line: 所在行
public func printLog<T>(_ message: T, file: String = #file, method: String = #function, line: Int = #line) {
#if DEBUG
    print("\n开始一段日志输出=========>\n[文件]:\((file as NSString).lastPathComponent)\n[所在行]:\(line)\n[方法名称]:\(method)\n[打印信息]:\(message)\n结束该段日志输出<=========")
#endif
}

//边距
let kMargin : CGFloat = 16.0

//圆角
let kCornerRadius3 : CGFloat = 3.0
let kCornerRadius4 : CGFloat = 4.0
let kCornerRadius6 : CGFloat = 6.0
let kCornerRadius8 : CGFloat = 8.0
let kCornerRadius12 : CGFloat = 12.0




///屏幕宽度
let KScreenWidth = UIScreen.main.bounds.size.width
///屏幕高度
let KScreenHeight = UIScreen.main.bounds.size.height
///导航栏高度
let k_Height_NavContentBar :CGFloat = 44.0
/** 状态栏高度 */
let k_Height_StatusBar :CGFloat = k_Height_statusBar()
/** 状态栏+导航栏的高度 */
let k_Height_NavigationtBarAndStatuBar: CGFloat = k_Height_NavContentBar + k_Height_StatusBar
/** 底部tabBar栏高度（不包含安全区，即：在 iphoneX 之前的手机） */
let k_TabBar_Height :CGFloat = 49.0
/** 底部导航栏高度（包括安全区），一般使用这个值 */
let k_Height_TabBar :CGFloat = k_Height_safeAreaInsetsBottom() + k_TabBar_Height

//比例
let kRadio = KScreenWidth / 375.0

// MARK: - 尺寸信息： -
/* 状态栏高度  20 或 44 */
// 然而从iOS 14开始，全面屏iPhone的状态栏高度不一定是 44 或 20 了，比如下面就是这些设备在iOS 14.1上的状态栏高度。（还可能时47、48）
/// ①、顶部状态栏高度（包括安全区）
func k_Height_statusBar() -> CGFloat {
    var statusBarHeight: CGFloat = 0;
    if #available(iOS 13.0, *) {
        let scene = UIApplication.shared.connectedScenes.first
        guard let windowScene = scene as? UIWindowScene else {return 0};
        guard let statusBarManager = windowScene.statusBarManager else {return 0}
        statusBarHeight = statusBarManager.statusBarFrame.height
    } else {
        statusBarHeight = UIApplication.shared.statusBarFrame.height
    }
    return statusBarHeight;
}

/// ②、顶部安全区高度 k_Height_safeAreaInsetsTop
func k_Height_safeAreaInsetsTop() -> CGFloat {
    if #available(iOS 13.0, *) {
        let scene = UIApplication.shared.connectedScenes.first
        guard let windowScene = scene as? UIWindowScene else {return 0} // guard：如果 expression 值计算为false，则执行代码块内的 guard 语句。(必须包含一个控制语句: return、 break、 continue 或 throw。)。as?：类型转换，(还有这两种：as、as!)
        guard let window = windowScene.windows.first else {return 0};
        return window.safeAreaInsets.top;
    }
    return 0
}

/// ③、底部安全区高度
func k_Height_safeAreaInsetsBottom() -> CGFloat {
    if #available(iOS 13.0, *) {
        let scene = UIApplication.shared.connectedScenes.first;
        guard let windowScene = scene as? UIWindowScene else {return 0};
        guard let window = windowScene.windows.first else {return 0};
        return window.safeAreaInsets.bottom;
    }
    return 0;
}

///获取系统版本号
func IOSVersion() -> Double {
    return (UIDevice.current.systemVersion as NSString).doubleValue
}
///组件化用类名创建控制器
func ClassFromString(className: String) -> UIViewController? {
    let appName = Bundle.main.object(forInfoDictionaryKey: "CFBundleName")
    
    let name = "\(appName!).\(className)"
    if let tmpClass = NSClassFromString(name) as? UIViewController.Type {
        return tmpClass.init()
    } else {
        return nil
    }
}

/// 版本号相同：
func systemVersionEqual(version:String) -> Bool {
    return UIDevice.current.systemVersion == version
}

/// 系统版本高于等于该version  测试发现只能传入带一位小数点的版本号  不然会报错    具体原因待探究
func systemVersionGreaterThan(version:String) -> Bool {
    return UIDevice.current.systemVersion.compare(version, options: .numeric, range: version.startIndex..<version.endIndex, locale: Locale(identifier:version)) != ComparisonResult.orderedAscending
}

//判断是否是 x、及x以上 系列
func isIphoneX() -> Bool {
    return k_Height_safeAreaInsetsBottom() > 0.0 // 底部安全区 > 0 时，
}


enum tabBarPageType : Int {
    case home //首页
    case service //服务
//    case message //消息
    case mine //我的
    case community //社区
}

func goTabBarBy(tabType : tabBarPageType) {

    var tabIndex : Int = 0
    switch tabType {
    case .home:
        tabIndex = 0
    case .service:
        tabIndex = 1
    case .community:
        tabIndex = 2
    case .mine:
        tabIndex = 3
    }
    
    if let vc = UIApplication.shared.keyWindow?.rootViewController as? YHTabBarViewController {
        vc.selectedIndex = tabIndex
    }
}

func goToMessagePage() {
    goTabBarBy(tabType: .home)
    UIViewController.current?.navigationController?.popToRootViewController(animated: false)
    let vc = YHMessageListVC()
    UIViewController.current?.navigationController?.pushViewController(vc)
}


// MARK: - 常量定义
class YhConstant {
    // MARK: - 登录信息
    static let KLoginedInfoKey = "KLoginedInfoKey"
    
    //登录后的用户信息
    static let kLoginUserInfo = "loginUserInfo"
    
    
    static let kShowAlertOfSuggestLatestVersion = "show_alert_suggest_latest_version"
    
}

extension YhConstant {
    // MARK: - bugly
    struct Bugly {
        static let appidForTest = "3b10faa43e"
        static let appidForRelease = "5dc2acc53e"
    }
    
    
    // MARK: - 神策
    struct SensorsAnalytics {
        static let urlForTest = "https://importsensors.galaxy-immi.com/sa?project=default"
        static let urlForRelease = "https://importsensors.galaxy-immi.com/sa?project=production_1"
    }
    
    
    // MARK: - 极光推送
    struct Jpush {
        static let appKey = "c6a9e10575b85ee90f3e8afe"
    }
    
    // MARK: - 微信相关
    struct Wechat {
        static let appKey = "wx06b21f3c7a5ba594"
        static let universalLink = "https://www.galaxy-immi.com/app1/"
    }
    
    // MARK: - 支付宝
    struct Alipay {
        // MARK: - 阿里云 手机号一键登录 秘钥信息
        static let kAliLoginDefaultSecretKey = "y4uQwHhb6PBfQVKlHou8SINaWIFHkovMalxWpiSjmV7iree+qKEEZHunaf5VN7d+YmHZIu8th0V1mM+JUCSNqrTT1s/rN1KCu5tWtABgzYuIhHoUtzPMB2NbRoQUF/cJj2DAjpvRQwWibWONTVyvtKUVUqhiL+fbYXM4OzXETetCAykppYUQt2Tzob9Jwz2RwOC7WrU4QyOyoa5dbavOysUjo2yv3oTRVFQbE1wdZBczDWpiqHfqUArZ4py7Q5sVuGvCoCvRcAE="
        
        
    }
    
    // MARK: -  通知相关 名称
    class YhNotification {
        //登录成功
        public static let didLoginSuccessNotifiction = Notification.Name(rawValue: "com.usleep.health.login.success")
        
        //退出成功
        public static let didLogoutSuccessNotifiction = Notification.Name(rawValue: "com.usleep.health.logout.success")
        
        //token 过期
        public static let tokenInvalidateNotifiction = Notification.Name(rawValue: "com.usleep.health.token.invalidate")
        
        //首页刷新通知
        public static let refreshHomePageNotifiction = Notification.Name(rawValue: "com.yinhe.homePage.refresh")
        
        //清空所有未读消息数
        public static let didMarkAllMessagesReadedNotifiction = Notification.Name(rawValue: "com.yinhe.msgPage.readAll")
        
        // 请求消息未读总数通知
        public static let didRequestUnreadMsgTotalCountNotification = Notification.Name(rawValue: "com.yinhe.msgPage.unreadMsgTotal")
        
        // 请求消息未读列表通知
        public static let didRequestUnreadMsgListNotification = Notification.Name(rawValue: "com.yinhe.msgPage.unreadList")
        
        // 请求通知权限通知
        public static let didReqeustNotifyPermissionNotification = Notification.Name(rawValue: "com.yinhe.msgPage.notifyPermission")
        
        //强制更新通知
        public static let didForceUpgradeNotifiction = Notification.Name(rawValue: "com.yinhe.version.forceUpgrade")
        
        // 刷新证件文件列表通知
        public static let refreshCertificateFileListNotifiction = Notification.Name(rawValue: "com.yinhe.certificate.updateFileList")
        
        // 点击文件清单条目通知
        public static let clickCertificateFileListItemNotifiction = Notification.Name(rawValue: "com.yinhe.certificate.clickFileListItem")
        
        // 点击文件清单空视图返回服务tab页
        public static let didClickFileListBackToServiceTabNotifiction = Notification.Name(rawValue: "com.yinhe.certificate.backToService")
        
        
        // 跳转 社区的活动页
        public static let goActivityVCNotifiction = Notification.Name(rawValue: "com.yinhe.goActivityVCNotifiction")
        
        // 跳转 社区的人脉页
        public static let goConnectionVCNotifiction = Notification.Name(rawValue: "com.yinhe.goConnectionVCNotifiction")
        
        // 点击了 首页的消息
        public static let  clickHomeMsgNotifiction = Notification.Name(rawValue: "com.yinhe.clickHomeMsgNotifiction")
        
        //接收到消息推送
        public static let didRevMsgNotifiction = Notification.Name(rawValue: "com.yinhe.didRevMsgNotifiction")
        
        // 去看一看点击后开始匹配用户
        public static let didLookPeopleSuccessNotifiction = Notification.Name(rawValue: "com.yinhe.look.people.success")
        
        // 改变底部tabbar上 分享View的展示状态
        public static let changeShareViewStatusOnTabBarNotifiction = Notification.Name(rawValue: "com.yinhe.change.shareView.status")
        
        
        //获取灰度参数
        public static let didRevUatParam = Notification.Name(rawValue: "com.yinhe.didRevUatParam")

    }
}
