//
//  NetBaseModel.swift
//  galaxy
//
//  Created by davidhuangA on 2023/12/28.
//  Copyright © 2023 www.davidhuang.com. All rights reserved.
//

import Foundation
import SmartCodable
import HandyJSON

enum NetWorkCode: Int {
    case success = 200
    case parseFail = 9527
}

struct NetBaseModel: SmartCodable {
    var data : SmartAny?
    var code : Int = -1
    var msg : String = ""
//    var other : SmartAny?
}

struct TestModel: SmartCodable {
    var test1 : String = ""
    var test2 : String = ""
    var test3 : String = ""
    
    enum CodingKeys: String, CodingKey {
        case test1
        case test2
        case test3 = "test333" //字段 映射
    }
}

struct NetWorkBaseModel: HandyJSON {
    var data : Any?
    var code : Int32 = -1
    var msg : String = ""
}
