//
//  YHVipLevelRightInfoCell.swift
//  galaxy
//
//  Created by Dufet on 2025/2/21.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVipLevelRightInfoView: UIView {
        
    lazy var lineView: UIView = {
        let v = UIView()
        v.backgroundColor = .init(hex: 0xE9ECF0)
        return v
    }()
    
    lazy var textLabel: UILabel = {
        let label = UILabel()
        label.text = ""
        label.textColor = .init(hex: 0x435163)
        label.textAlignment = .center
        label.font = .PFSC_R(ofSize: 12)
        return label
    }()
    
    lazy var iconImgV: UIImageView = {
        let v = UIImageView(image: UIImage(named: ""))
        return v
    }()
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func clear() {
        self.textLabel.text = ""
        self.iconImgV.image = UIImage(named: "")
    }
    
    func createUI() {
        
        self.addSubview(textLabel)
        self.addSubview(iconImgV)
        self.addSubview(lineView)
        
        lineView.snp.makeConstraints { make in
            make.left.top.bottom.equalToSuperview()
            make.width.equalTo(0.5)
        }
        
        textLabel.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        iconImgV.snp.makeConstraints { make in
            make.width.height.equalTo(16)
            make.centerX.equalToSuperview()
            make.centerY.equalToSuperview()
        }
    }
}

class YHVipLevelRightInfoCell: UITableViewCell {

    static let cellReuseIdentifier = "YHVipLevelRightInfoCell"
    static let baseTag = 9527
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }

    func setupUI() {
        
        self.backgroundColor = .clear
        self.selectionStyle = .none
        
        var lastV: YHVipLevelRightInfoView?
        for index in 0...3 {
            let v = YHVipLevelRightInfoView(frame: .zero)
            v.tag = Self.baseTag + index
            v.lineView.isHidden = index == 0
            contentView.addSubview(v)
            
            v.snp.makeConstraints { make in
                make.top.bottom.equalToSuperview()
                make.width.equalTo(self.snp.width).multipliedBy(1.0/4.0)
                if let last = lastV {
                    make.left.equalTo(last.snp.right)
                } else {
                    make.left.equalToSuperview()
                }
            }
            lastV = v
        }
    }
    
    func updateModel(_ model: YHVipLevelRightInfoModel) {
        
        guard let v0 = self.contentView.viewWithTag(Self.baseTag+0) as? YHVipLevelRightInfoView else { return }
        guard let v1 = self.contentView.viewWithTag(Self.baseTag+1) as? YHVipLevelRightInfoView else { return }
        guard let v2 = self.contentView.viewWithTag(Self.baseTag+2) as? YHVipLevelRightInfoView else { return }
        guard let v3 = self.contentView.viewWithTag(Self.baseTag+3) as? YHVipLevelRightInfoView else { return }
        v0.clear()
        v1.clear()
        v2.clear()
        v3.clear()

        if model.type == .baseRightSection {
            v0.textLabel.text = model.text1
            v1.textLabel.text = model.text2
            v2.textLabel.text = model.text3
            v3.textLabel.text = model.text4
            v0.textLabel.textColor = .brandMainColor
            v1.textLabel.textColor = .brandMainColor
            v2.textLabel.textColor = .brandMainColor
            v3.textLabel.textColor = .brandMainColor
            
        } else if model.type == .hightRightSection {
            v0.textLabel.text = model.text1
            v1.textLabel.text = model.text2
            v2.textLabel.text = model.text3
            v3.textLabel.text = model.text4
            v0.textLabel.textColor = .init(hex: 0xEDA43D)
            v1.textLabel.textColor = .init(hex: 0xEDA43D)
            v2.textLabel.textColor = .init(hex: 0xEDA43D)
            v3.textLabel.textColor = .init(hex: 0xEDA43D)
            
        } else if model.type == .text {
            v0.textLabel.text = model.text1
            v1.textLabel.text = model.text2
            v2.textLabel.text = model.text3
            v3.textLabel.text = model.text4
            v0.textLabel.textColor = .init(hex: 0x435163)
            v1.textLabel.textColor = .init(hex: 0x435163)
            v2.textLabel.textColor = .init(hex: 0x435163)
            v3.textLabel.textColor = .init(hex: 0x435163)
            
        } else if model.type == .own {
            let img1 = model.level1 == 1 ?  "mine_vip_right_own_1" : "mine_vip_right_own_0"
            let img2 = model.level2 == 1 ?  "mine_vip_right_own_1" : "mine_vip_right_own_0"
            let img3 = model.level3 == 1 ?  "mine_vip_right_own_1" : "mine_vip_right_own_0"
            let img4 = model.level4 == 1 ?  "mine_vip_right_own_1" : "mine_vip_right_own_0"
            v0.iconImgV.image = UIImage(named: img1)
            v1.iconImgV.image = UIImage(named: img2)
            v2.iconImgV.image = UIImage(named: img3)
            v3.iconImgV.image = UIImage(named: img4)
        }
    }
}
