//
//  YHActivityDetailCell1.swift
//  galaxy
//
//  Created by davidhuangA on 2024/7/1.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import SmartCodable
class YHActivityCoverItem: SmartCodable {
    var url: String = ""
    let width: CGFloat = KScreenWidth-40.0
    var height: CGFloat = KScreenWidth-40.0
    lazy var imgView: UIImageView =  {
        let view =  UIImageView(image: UIImage(named: "global_default_image"))
        view.contentMode = .scaleAspectFill
        view.clipsToBounds = true
        return view
    }()
    
    required init() {
    }
}

class YHActivityDetailCell1: UITableViewCell {

    static let cellReuseIdentifier = "YHActivityDetailCell1"

    var dataModel: YHActivityDetailModel = YHActivityDetailModel() {
        didSet {
            updateUI()
        }
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private lazy var bottomLine: UIView = {
        let view = UIView()
        view.backgroundColor = UIColor.separatorColor
        return view
    }()
    
    lazy var nameLabel: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor
        lable.textAlignment = .left
        lable.font = UIFont.PFSC_M(ofSize: 17)
        lable.text = "活动详情"
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var describeLable: UILabel = {
        let lable = UILabel()
        lable.textColor = UIColor.mainTextColor70
        lable.textAlignment = .left
        lable.lineBreakMode = .byCharWrapping
        lable.font = UIFont.PFSC_R(ofSize: 14)
        lable.numberOfLines = 0
        return lable
    }()
    
    lazy var imgsContentView: UIView = {
        let view = UIView()
        view.clipsToBounds = true
        return view
    }()
    
}

extension YHActivityDetailCell1 {
    
    func updateUI() {
       
        describeLable.text = dataModel.introduce
       // 创建NSMutableAttributedString实例
       let attributedText = NSMutableAttributedString(string: dataModel.introduce)
       
       // 设置行距，这里设置为10.0
       let paragraphStyle = NSMutableParagraphStyle()
       paragraphStyle.lineSpacing = 6.0 // 设置行距
       
       // 将段落样式添加到NSMutableAttributedString
       attributedText.addAttribute(.paragraphStyle, value: paragraphStyle, range: NSRange(location: 0, length: attributedText.length))
       
       // 设置UILabel的attributedText属性
        describeLable.attributedText = attributedText
        
        describeLable.snp.updateConstraints { make in
            let topMargin = dataModel.introduce.isEmpty ? 0.0 : 24.0
            make.top.equalTo(nameLabel.snp.bottom).offset(topMargin)
        }
        
        imgsContentView.removeSubviews()

        var theLastView: UIView?
        var totalImgHeight = 0.0
        for (index, item) in dataModel.coverItems.enumerated() {
            totalImgHeight += item.height
            self.imgsContentView.addSubview(item.imgView)
            item.imgView.snp.remakeConstraints { make in
                var gap = 0.0
                if index == 0 {
                    gap = item.height > 0 ? 24.0 : 0.0
                    make.top.equalTo(self.imgsContentView.snp.top).offset(gap)
                } else {
                    if let lastView = theLastView {
                        gap = item.height > 0 ? 24.0 : 0.0
                        make.top.equalTo(lastView.snp.bottom).offset(gap)
                    }
                }
                totalImgHeight += gap
                make.height.equalTo(item.height)
                make.left.right.equalToSuperview()
            }
            theLastView = item.imgView
        }
        imgsContentView.snp.updateConstraints { make in
            let top2Margin = self.dataModel.coverItems.count > 0 ? 24.0 : 0.0
            make.top.equalTo(describeLable.snp.bottom).offset(top2Margin)
            let imgsHeight = self.dataModel.coverItems.count <= 0 ? 0.0 : totalImgHeight
            make.height.equalTo(imgsHeight)
        }
        self.setNeedsLayout()
        self.layoutIfNeeded()
    }
    
    func setupUI() {
        backgroundColor = .clear
        contentView.backgroundColor = .clear
        selectionStyle = .none
        
        self.contentView.addSubview(bottomLine)
        self.contentView.addSubview(nameLabel)
        self.contentView.addSubview(describeLable)
        self.contentView.addSubview(imgsContentView)
        
        nameLabel.setContentCompressionResistancePriority(.required, for: .vertical)
        nameLabel.setContentHuggingPriority(.required, for: .vertical)
        
        describeLable.setContentCompressionResistancePriority(.required, for: .vertical)
        describeLable.setContentHuggingPriority(.required, for: .vertical)
        
        bottomLine.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalToSuperview()
            make.height.equalTo(1)
        }
        
        nameLabel.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(bottomLine.snp.bottom).offset(24)
        }
        
        describeLable.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(nameLabel.snp.bottom).offset(24)
        }
        
        imgsContentView.snp.makeConstraints { make in
            make.left.equalTo(20)
            make.right.equalTo(-20)
            make.top.equalTo(describeLable.snp.bottom).offset(24)
            make.height.equalTo(0.0)
//            make.bottom.equalTo(-24)
            make.bottom.equalToSuperview()
        }
    }
}
