//
//  YHPreviewInfoCertificatePictureItemsView.swift
//  galaxy
//
//  Created by davidhuangA on 2024/2/25.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

/*
 *证件照片 类型 view
 */

class YHPreviewInfoCertificatePictureItemsView: UIView {
    var dataModel: YHPreviewInfoSessionModel? {
        didSet {
            updateUI()
        }
    }
}

extension YHPreviewInfoCertificatePictureItemsView {
    func updateUI() {
        guard let model = dataModel else { return }
        guard let arrData = model.cellData2, arrData.count > 0 else { return }
        
        let sessionView = YHPreviewInfoSingleLineTitleView()
        sessionView.updateTitle(title: model.cellTitle)
        addSubview(sessionView)
        sessionView.snp.makeConstraints { make in
            make.top.equalToSuperview()
            make.right.equalToSuperview().offset(-0)
            make.left.equalToSuperview().offset(0)
            make.height.equalTo(YHPreviewInfoSingleLineTitleView.viewH)
        }
        
        var tmp: UIView = sessionView
        for (index0, item0) in arrData.enumerated() {
            let view = YHPreviewInfoCertificatePictureItemView()
            view.dataModel = item0
            addSubview(view)
            if index0 == arrData.count - 1 {
                view.snp.makeConstraints { make in
                    make.top.equalTo(tmp.snp.bottom)
                    make.right.equalToSuperview()
                    make.left.equalToSuperview()
                    
                    make.bottom.equalToSuperview()
                    
                    view.bottomLine.isHidden = true
                }
            } else {
                view.snp.makeConstraints { make in
                    make.top.equalTo(tmp.snp.bottom)
                    make.right.equalToSuperview()
                    make.left.equalToSuperview()
                }
                view.bottomLine.isHidden = false
            }
            tmp = view
        }
    }
}
