//
//  CustomNavigationController.swift
//  DYZB
//
//  Created by 1 on 16/10/14.
//  Copyright © 2016年 小码哥. All rights reserved.
//

import UIKit
// import TUIConversation

class YHNavigationController: UINavigationController {

    override func pushViewController(_ viewController: UIViewController, animated: Bool) {
        // 隐藏要push的控制器的tabbar
        if viewControllers.count > 0 {
            viewController.hidesBottomBarWhenPushed = true
        }
        super.pushViewController(viewController, animated: animated)
    }
    
    override func popViewController(animated: Bool) -> UIViewController? {
        printLog("popViewController")
        return super.popViewController(animated: animated)
    }
    
    override func setNavigationBarHidden(_ hidden: Bool, animated: Bool) {
        // 允许手动调用生效，但阻断 GKNavigationBar 的自动调用
//        if !(viewControllers.last?.isKind(of: TUIConversationListController.self) ?? false) {
//            super.setNavigationBarHidden(hidden, animated: animated)
//        }
        if let lastVC = viewControllers.last {
            let className = String(describing: type(of: lastVC))
            if !className.hasPrefix("TUI") { // 模糊匹配类名
                super.setNavigationBarHidden(hidden, animated: animated)
            }
        }
    }
}

// extension YHNavigationController: UIGestureRecognizerDelegate {
//    func gestureRecognizerShouldBegin(_ gestureRecognizer: UIGestureRecognizer) -> Bool {
//        if self.viewControllers.count <= 1 {
//            return false
//        }
//        return true
//    }
//    
//    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldReceive touch: UITouch) -> Bool {
//        if touch.view == gestureRecognizer.view {
//            return true
//        }
//        return false
//    }
//    
//    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldRecognizeSimultaneouslyWith otherGestureRecognizer: UIGestureRecognizer) -> Bool {
//        return false
//    }
// }
