//
//  YHVisaRenewalPayMemberCell.swift
//  galaxy
//
//  Created by alexzzw on 2025/3/10.
//  Copyright © 2025 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit

class YHVisaRenewalPayMemberCell: YHResignDocumentCell {

    static let cellReuseIdentifier = "YHVisaRenewalPayMemberCell"
    
    private lazy var iconView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    private lazy var infoTitleLabel: UILabel = {
        let label = UILabel()
        label.font = .PFSC_M(ofSize: 15)
        label.textColor = .mainTextColor
        label.numberOfLines = 0
        return label
    }()
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    func setupCellInfo(title: String) {
        infoTitleLabel.text = title
    }
}

extension YHVisaRenewalPayMemberCell {
    
    private func setupUI() {
        updateCellCorner(.mid)
        subContainerView.addSubview(iconView)
        subContainerView.addSubview(infoTitleLabel)
        
        iconView.setContentCompressionResistancePriority(.required, for: .horizontal)
        infoTitleLabel.setContentCompressionResistancePriority(.defaultLow, for: .horizontal)
        
        iconView.snp.makeConstraints { make in
            make.left.equalToSuperview().offset(18)
            make.width.equalTo(4)
            make.height.equalTo(15)
            make.centerY.equalTo(infoTitleLabel)
        }
        
        infoTitleLabel.snp.makeConstraints { make in
            make.left.equalTo(iconView.snp.right).offset(12)
            make.top.equalToSuperview().offset(20)
            make.bottom.equalToSuperview().offset(-16)
            make.right.equalToSuperview().offset(-18)
        }
    }
}
